<?php
/** Don't load directly */
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'foxiz_register_options_category' ) ) {
	function foxiz_register_options_category() {

		$prefix = 'category_';

		return [
			'id'     => 'foxiz_config_section_category',
			'title'  => esc_html__( 'Category', 'foxiz' ),
			'icon'   => 'el el-folder-open',
			'desc'   => esc_html__( 'These are global category settings. The settings below will apply to all category pages.', 'foxiz' ),
			'fields' => [
				[
					'id'    => $prefix . 'settings_notice',
					'type'  => 'info',
					'style' => 'info',
					'desc'  => esc_html__( 'To edit for individual categories, navigate to "Admin Dashboard > Posts > Categories > Edit".', 'foxiz' ),
				],
				[
					'id'     => 'section_start_category_site_header',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Site Header', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'header_style',
					'type'     => 'select',
					'title'    => esc_html__( 'Header Layout', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a website header layout for the category pages.', 'foxiz' ),
					'options'  => foxiz_config_header_style( true, true ),
					'default'  => '0',
				],
				[
					'id'          => $prefix . 'header_template',
					'type'        => 'textarea',
					'title'       => esc_html__( 'Or Use Ruby Template for Site Header', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input a Ruby Template shortcode for displaying as the website header for the category pages.', 'foxiz' ),
					'description' => esc_html__( 'This setting will override all "Header Layout" settings. Leave it blank if you would like to use the "Header Layout" setting.', 'foxiz' ),
					'placeholder' => esc_html__( '[Ruby_E_Template id="1"]', 'foxiz' ),
					'rows'        => 2,
					'default'     => '',
				],
				[
					'id'          => $prefix . 'nav_style',
					'type'        => 'select',
					'title'       => esc_html__( 'Navigation Bar Style', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select navigation bar style for the site header in the category pages.', 'foxiz' ),
					'description' => esc_html__( 'This setting will apply only to pre-defined headers: 1, 2, 3 and 5.', 'foxiz' ),
					'options'     => [
						'0'        => esc_html__( '- Default -', 'foxiz' ),
						'shadow'   => esc_html__( 'Shadow', 'foxiz' ),
						'border'   => esc_html__( 'Bottom Border', 'foxiz' ),
						'd-border' => esc_html__( 'Dark Bottom Border', 'foxiz' ),
						'none'     => esc_html__( 'None', 'foxiz' ),
					],
					'default'     => '0',
				],
				[
					'id'     => 'section_end_category_site_header',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_category_icon',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Entry Category Icon', 'foxiz' ),
					'subtitle' => esc_html__( 'PLEASE NOTE: The setting only applies to predefined templates. For the category page built with the Ruby Template please adjust the setting in the "Elementor Block Settings > Style > Entry Category > Replace Category by Taxonomy".', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'          => $prefix . 'entry_tag',
					'title'       => esc_html__( 'Replace Category by Post Tags', 'foxiz' ),
					'subtitle'    => esc_html__( 'Retaining identical category information within the category is not a good idea. Instead, replace it with post tags to enhance engagement.', 'foxiz' ),
					'description' => esc_html__( 'To set maximum post tags to show, navigate to "Theme Options > Theme Design > Entry Category > Max Category Icons if Choose Post Tags" or select the primary tag in the single post settings panel.', 'foxiz' ),
					'type'        => 'switch',
					'default'     => true,
				],
				[
					'id'     => 'section_end_category_icon',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_category_header',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Category Header', 'foxiz' ),
					'subtitle' => esc_html__( 'Please ensure that you construct the header template or add an H1 tag somewhere if you choose to disable the header to avoid SEO issues.', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'       => $prefix . 'category_header',
					'title'    => esc_html__( 'Category Header', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select a category header layout for the category pages.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_category_header(),
					'default'  => '1',
				],
				[
					'id'       => $prefix . 'pattern',
					'title'    => esc_html__( 'Background Pattern', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a background pattern for the category header.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_archive_header_bg(),
					'default'  => 'dot',
				],
				[
					'id'       => $prefix . 'subcategory',
					'title'    => esc_html__( 'Subcategories List', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the subcategory list in the category header.', 'foxiz' ),
					'type'     => 'switch',
					'default'  => true,
				],
				[
					'id'     => 'section_end_category_header',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_category_template',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Top Template Builder', 'foxiz' ),
					'notice' => [
						esc_html__( 'These settings enable you to create a custom featured posts area at the top of the category page with ease.', 'foxiz' ),
						esc_html__( 'Please note that these settings will be overridden by the "Top Section" settings in the individual category settings panel.', 'foxiz' ),
					],
					'indent' => true,
				],
				[
					'id'          => $prefix . 'template',
					'title'       => esc_html__( 'Template Shortcode', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input a "Ruby Template" shortcode to embed it after the category header, e.g: [Ruby_E_Template id="1"]', 'foxiz' ),
					'description' => esc_html__( 'This setting will be overridden by "template shortcode" in the individual category setting panel.', 'foxiz' ),
					'type'        => 'textarea',
					'placeholder' => '[Ruby_E_Template id="1"]',
					'rows'        => 2,
					'default'     => '',
				],
				[
					'id'       => $prefix . 'template_display',
					'title'    => esc_html__( 'Display Condition', 'foxiz' ),
					'subtitle' => esc_html__( 'Choose where the template should appear: on the first page only or on all pages.', 'foxiz' ),
					'type'     => 'select',
					'options'  => [
						'1' => esc_html__( 'Show on the first page', 'foxiz' ),
						'2' => esc_html__( 'Show on all pages', 'foxiz' ),
					],
					'default'  => '1',
				],
				[
					'id'     => 'section_end_category_template',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_category_posts_per_page',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Posts per Page', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'          => $prefix . 'posts_per_page',
					'title'       => esc_html__( 'Posts per Page', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select posts per page for the categories. Leave this option blank to set the default.', 'foxiz' ),
					'description' => esc_html__( 'This setting will override on "Dashboard > Settings > Reading > Blog pages show at most" setting. It will also apply to the "or Use Ruby Template for the Post Listing".', 'foxiz' ),
					'type'        => 'text',
					'class'       => 'small-text',
					'validate'    => 'numeric',
					'default'     => '',
				],
				[
					'id'     => 'section_end_category_posts_per_page',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_category_template_global',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Global Listing Template', 'foxiz' ),
					'notice' => [
						esc_html__( 'Create a blog listing layout with Ruby Template via Elementor page builder and assign the template shortcode here to create your own layout.', 'foxiz' ),
						esc_html__( 'Ensure "Use WP Global Query" under "Template Builder - Global Query > Query Mode" is set in a block of your template to help the system understand that it is the main query.', 'foxiz' ),
						esc_html__( 'All settings related to predefined layouts (sections below) will not apply if you are using a template.', 'foxiz' ),
					],
					'indent' => true,
				],
				[
					'id'       => $prefix . 'layout',
					'title'    => esc_html__( 'Predefined Layout', 'foxiz' ),
					'subtitle' => esc_html__( 'Select blog listing layout for the category pages.', 'foxiz' ),
					'type'     => 'image_select',
					'options'  => foxiz_config_blog_layout(),
					'default'  => 'grid_1',
				],
				[
					'id'          => $prefix . 'template_global',
					'title'       => esc_html__( 'or Use Ruby Template for the Post Listing', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input a "Ruby Template" shortcode to display as the main listing posts (blog), e.g: [Ruby_E_Template id="1"]', 'foxiz' ),
					'description' => esc_html__( 'This setting will override the "Predefined Layout" above. Leave blank to use the Predefined Layout setting.', 'foxiz' ),
					'type'        => 'textarea',
					'rows'        => 2,
					'placeholder' => '[Ruby_E_Template id="1"]',
					'default'     => '',
				],
				[
					'id'     => 'section_end_category_template_global',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_category_blog_header',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Post Listing - Heading', 'foxiz' ),
					'notice' => [
						esc_html__( 'These settings will only take effect if you select the Predefined layout for displaying the global post listing.', 'foxiz' ),
						esc_html__( 'The theme supports heading dynamic content, Please read the documentation for further information.', 'foxiz' ),
					],
					'indent' => true,
				],
				[
					'id'       => $prefix . 'blog_heading',
					'title'    => esc_html__( 'Heading', 'foxiz' ),
					'subtitle' => esc_html__( 'Input a heading for the post listing. Leave blank to disable this section', 'foxiz' ),
					'type'     => 'text',
					'default'  => 'Latest {category} News',
				],
				[
					'id'       => $prefix . 'blog_heading_layout',
					'title'    => esc_html__( 'Heading Layout', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a heading layout for the heading.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_heading_layout( true ),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'blog_heading_tag',
					'title'    => esc_html__( 'Heading HTML Tag', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a HTML tag for this heading. Leave this option blank to set the default.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_heading_tag(),
					'default'  => '0',
				],
				[
					'id'          => $prefix . 'blog_heading_size',
					'title'       => esc_html__( 'Heading Font Size (Desktop)', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input a custom font size value for the category heading (in pixels) on the desktop.', 'foxiz' ),
					'description' => esc_html__( 'Navigate to "Heading Design" panel to edit font size for table and mobile device.', 'foxiz' ),
					'type'        => 'text',
					'validate'    => 'numeric',
					'default'     => '',
				],
				[
					'id'     => 'section_end_category_blog_header',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_category_blog_layout',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Post Listing - Columns', 'foxiz' ),
					'subtitle' => esc_html__( 'These settings will only take effect if you select the Predefined layout for displaying the global post listing.', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'       => $prefix . 'columns',
					'title'    => esc_html__( 'Columns on Desktop', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the total number of columns to show per row on desktop devices.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_columns(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'columns_tablet',
					'title'    => esc_html__( 'Columns on Tablet', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the total number of columns to show per row on tablet devices.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_columns(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'columns_mobile',
					'title'    => esc_html__( 'Columns on Mobile', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the total number of columns to show per row on mobile devices.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_columns( [ '0', '1', '2' ] ),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'column_gap',
					'title'    => esc_html__( 'Column Gap', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a spacing between columns.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_column_gap(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_category_layout',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_category_blog_sidebar',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Post Listing - Sidebar', 'foxiz' ),
					'subtitle' => esc_html__( 'These settings will only take effect if you select the Predefined layout for displaying the global post listing.', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'       => $prefix . 'sidebar_position',
					'type'     => 'image_select',
					'title'    => esc_html__( 'Sidebar Position', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a sidebar position or disable it for the latest blog section', 'foxiz' ),
					'options'  => foxiz_config_sidebar_position(),
					'default'  => 'none',
				],
				[
					'id'       => $prefix . 'sidebar_name',
					'type'     => 'select',
					'title'    => esc_html__( 'Assign a Sidebar', 'foxiz' ),
					'subtitle' => esc_html__( 'Assign a widget section for the sidebar for the latest blog section if it is enabled.', 'foxiz' ),
					'options'  => foxiz_config_sidebar_name( false ),
					'default'  => 'foxiz_sidebar_default',
				],
				[
					'id'       => $prefix . 'sticky_sidebar',
					'type'     => 'select',
					'title'    => esc_html__( 'Sticky Sidebar', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable sticky sidebar feature.', 'foxiz' ),
					'options'  => [
						'0'  => esc_html__( '- Default -', 'foxiz' ),
						'1'  => esc_html__( 'Sticky Sidebar', 'foxiz' ),
						'2'  => esc_html__( 'Sticky Last Widget', 'foxiz' ),
						'-1' => esc_html__( 'Disable', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'     => 'section_end_category_blog_sidebar',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_category_design',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Post Listing - Design', 'foxiz' ),
					'notice' => [
						esc_html__( 'These settings will only take effect if you select the Predefined layout for displaying the global post listing.', 'foxiz' ),
						esc_html__( 'The theme\'s default settings are set to use the "Standard Blog Design". However, you can customize these settings using the options below', 'foxiz' ),
					],
					'indent' => true,
				],
				[
					'id'       => $prefix . 'crop_size',
					'title'    => esc_html__( 'Featured Image Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a featured image size to optimize with the columns setting.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_crop_size(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'display_ratio',
					'type'     => 'text',
					'title'    => esc_html__( 'Custom Featured Ratio', 'foxiz' ),
					'subtitle' => esc_html__( 'Input custom ratio percent (height*100/width) for featured image you would like. e.g. 50', 'foxiz' ),
					'default'  => '',
				],
				[
					'id'          => $prefix . 'entry_category',
					'title'       => esc_html__( 'Entry Category', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a layout for the entry category to display in the post listing.', 'foxiz' ),
					'description' => esc_html__( 'The setting will not apply if the selected blog layout does not support the selected entry category.', 'foxiz' ),
					'type'        => 'select',
					'options'     => foxiz_config_extended_entry_category( true ),
					'default'     => '0',
				],
				[
					'id'       => $prefix . 'hide_category',
					'type'     => 'select',
					'title'    => esc_html__( 'Responsive - Hide Entry Category', 'foxiz' ),
					'subtitle' => esc_html__( 'Hide the entry category on tablet and mobile devices.', 'foxiz' ),
					'options'  => [
						'0'      => esc_html__( '- Default -', 'foxiz' ),
						'mobile' => esc_html__( 'On Mobile', 'foxiz' ),
						'tablet' => esc_html__( 'On Tablet', 'foxiz' ),
						'all'    => esc_html__( 'On Tablet & Mobile', 'foxiz' ),
						'-1'     => esc_html__( 'Disable', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'title_tag',
					'title'    => esc_html__( 'Title HTML Tag', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a title HTML tag for the post title.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_heading_tag(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'title_size',
					'title'    => esc_html__( 'Desktop - Title Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (in pixels) for the post title on desktop devices. Leave blank to set it as the default.', 'foxiz' ),
					'type'     => 'text',
					'default'  => '',
				],
				[
					'id'       => $prefix . 'title_size_tablet',
					'title'    => esc_html__( 'Tablet - Title Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (in pixels) for the post title on tablet devices. Leave blank to set it as the default.', 'foxiz' ),
					'type'     => 'text',
					'default'  => '',
				],
				[
					'id'       => $prefix . 'title_size_mobile',
					'title'    => esc_html__( 'Mobile - Title Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (in pixels) for the post title on mobile devices. Leave blank to set it as the default.', 'foxiz' ),
					'type'     => 'text',
					'default'  => '',
				],
				[
					'id'       => $prefix . 'entry_meta_bar',
					'type'     => 'select',
					'title'    => esc_html__( 'Entry Meta Bar', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the entry meta tags you want to show.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_bar(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'entry_meta',
					'type'     => 'select',
					'multi'    => true,
					'title'    => esc_html__( 'Entry Meta Tags', 'foxiz' ),
					'required' => [ $prefix . 'entry_meta_bar', '=', 'custom' ],
					'subtitle' => esc_html__( 'Customize the appearance of the entry meta. Select "Disable" only if you wish to hide the entry meta.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_tags(),
					'default'  => [],
				],
				[
					'id'       => $prefix . 'review',
					'type'     => 'select',
					'title'    => esc_html__( 'Review Meta', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select setting for entry review meta.', 'foxiz' ),
					'options'  => foxiz_config_entry_review( true ),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'review_meta',
					'type'     => 'select',
					'title'    => esc_html__( 'Review Meta Description', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the meta description at the end of the review bar.', 'foxiz' ),
					'options'  => foxiz_config_review_desc_dropdown(),
					'default'  => '0',
				],
				[
					'id'          => $prefix . 'tablet_hide_meta',
					'type'        => 'text',
					'title'       => esc_html__( 'Hide Entry Meta on Tablet', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input the entry meta tags that you want to hide on tablet devices, separate by comma. e.g. avatar, author... Keys include: [avatar, author, date, category, tag, view, comment, update, read, like, bookmark, custom]. Input -1 to re-enable all tags.', 'foxiz' ),
					'placeholder' => esc_html__( 'avatar,author', 'foxiz' ),
					'default'     => '',
				],
				[
					'id'          => $prefix . 'mobile_hide_meta',
					'type'        => 'text',
					'title'       => esc_html__( 'Hide Entry Meta on Mobile', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input the entry meta tags that you want to hide on mobile devices, separate by comma. e.g. avatar, author... Keys include: [avatar, author, date, category, tag, view, comment, update, read, like, bookmark, custom]. Input -1 to re-enable all tags.', 'foxiz' ),
					'placeholder' => esc_html__( 'avatar,author', 'foxiz' ),
					'default'     => '',
				],
				[
					'id'       => $prefix . 'bookmark',
					'type'     => 'select',
					'title'    => esc_html__( 'Bookmark Icon', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the bookmark icon.', 'foxiz' ),
					'options'  => foxiz_config_switch_dropdown(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'entry_format',
					'type'     => 'select',
					'title'    => esc_html__( 'Post Format Icon', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select setting for the post format.', 'foxiz' ),
					'options'  => foxiz_config_entry_format( true ),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'excerpt',
					'type'     => 'select',
					'title'    => esc_html__( 'Excerpt', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select settings for the post excerpt.', 'foxiz' ),
					'options'  => foxiz_config_excerpt_dropdown(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'excerpt_length',
					'type'     => 'text',
					'class'    => 'small-text',
					'validate' => 'numeric',
					'title'    => esc_html__( 'Excerpt - Max Length', 'foxiz' ),
					'required' => [ $prefix . 'excerpt', '=', '1' ],
					'subtitle' => esc_html__( 'select max length of the post excerpt.', 'foxiz' ),
					'desc'     => esc_html__( 'Leave this option blank or set 0 to disable.', 'foxiz' ),
					'default'  => '',
				],
				[
					'id'          => $prefix . 'excerpt_source',
					'title'       => esc_html__( 'Excerpt - Source', 'foxiz' ),
					'subtitle'    => esc_html__( 'Where to get the post excerpt.', 'foxiz' ),
					'description' => esc_html__( 'When you select "use title tagline". if it is empty, it will fallback to the post excerpt or content.', 'foxiz' ),
					'required'    => [ $prefix . 'excerpt', '=', '1' ],
					'type'        => 'select',
					'options'     => foxiz_config_excerpt_source(),
					'default'     => 'tagline',
				],
				[
					'id'       => $prefix . 'hide_excerpt',
					'type'     => 'select',
					'title'    => esc_html__( 'Responsive - Hide Excerpt', 'foxiz' ),
					'subtitle' => esc_html__( 'Hide the post excerpt on tablet and mobile devices.', 'foxiz' ),
					'options'  => [
						'0'      => esc_html__( '- Default -', 'foxiz' ),
						'mobile' => esc_html__( 'On Mobile', 'foxiz' ),
						'tablet' => esc_html__( 'On Tablet', 'foxiz' ),
						'all'    => esc_html__( 'On Tablet & Mobile', 'foxiz' ),
						'-1'     => esc_html__( 'Disable', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'readmore',
					'type'     => 'select',
					'title'    => esc_html__( 'Read More Button', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the read more button.', 'foxiz' ),
					'options'  => foxiz_config_switch_dropdown(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_category_design',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_category_blog_pagination',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Post Listing - Pagination', 'foxiz' ),
					'subtitle' => esc_html__( 'These settings will only take effect if you select the Predefined layout for displaying the global post listing.', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'       => $prefix . 'pagination',
					'title'    => esc_html__( 'Pagination Type', 'foxiz' ),
					'subtitle' => esc_html__( 'Select pagination type for the category pages.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_pagination(),
					'default'  => 'number',
				],
				[
					'id'     => 'section_end_category_blog_pagination',
					'type'   => 'section',
					'class'  => 'ruby-section-end no-border',
					'indent' => false,
				],
			],
		];
	}
}

if ( ! function_exists( 'foxiz_register_options_blog' ) ) {
	function foxiz_register_options_blog() {

		$prefix = 'blog_';

		return [
			'id'     => 'foxiz_config_section_blog',
			'title'  => esc_html__( 'Blog Index', 'foxiz' ),
			'icon'   => 'el el-bold',
			'desc'   => esc_html__( 'Customize the appearance and layout of the blog.', 'foxiz' ),
			'fields' => [
				[
					'id'     => 'section_start_blog_header',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Site Header', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'header_style',
					'type'     => 'select',
					'title'    => esc_html__( 'Header Layout', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a website header layout for the blog page.', 'foxiz' ),
					'options'  => foxiz_config_header_style( true, true ),
					'default'  => '0',
				],
				[
					'id'          => $prefix . 'header_template',
					'type'        => 'textarea',
					'title'       => esc_html__( 'Or Use Ruby Template for Site Header', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input a Ruby Template shortcode for displaying as the website header for the blog page.', 'foxiz' ),
					'description' => esc_html__( 'This setting will override all "Header Layout" settings. Leave it blank to disable.', 'foxiz' ),
					'placeholder' => esc_html__( '[Ruby_E_Template id="1"]', 'foxiz' ),
					'rows'        => 2,
					'default'     => '',
				],
				[
					'id'          => $prefix . 'nav_style',
					'type'        => 'select',
					'title'       => esc_html__( 'Navigation Bar Style', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select navigation bar style for the site header in the blog page.', 'foxiz' ),
					'description' => esc_html__( 'This setting will apply only to pre-defined headers: 1, 2, 3 and 5.', 'foxiz' ),
					'options'     => [
						'0'        => esc_html__( '- Default -', 'foxiz' ),
						'shadow'   => esc_html__( 'Shadow', 'foxiz' ),
						'border'   => esc_html__( 'Bottom Border', 'foxiz' ),
						'd-border' => esc_html__( 'Dark Bottom Border', 'foxiz' ),
						'none'     => esc_html__( 'None', 'foxiz' ),
					],
					'default'     => '0',
				],

				[
					'id'     => 'section_end_blog_header',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_blog_builder',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Top & Bottom Area Template Builder', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'          => $prefix . 'template',
					'type'        => 'textarea',
					'title'       => esc_html__( 'Top Area Template Shortcode', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input a "Ruby Template" shortcode to embed it the top of the blog page, e.g: [Ruby_E_Template id="1"]', 'foxiz' ),
					'placeholder' => '[Ruby_E_Template id="1"]',
					'rows'        => 2,
					'default'     => '',
				],
				[
					'id'          => $prefix . 'template_bottom',
					'type'        => 'textarea',
					'title'       => esc_html__( 'Bottom Area Template Shortcode', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input a "Ruby Template" shortcode to embed it the bottom of the blog page, e.g: [Ruby_E_Template id="1"]', 'foxiz' ),
					'placeholder' => '[Ruby_E_Template id="1"]',
					'rows'        => 2,
					'default'     => '',
				],
				[
					'id'       => $prefix . 'template_display',
					'title'    => esc_html__( 'Display Condition', 'foxiz' ),
					'subtitle' => esc_html__( 'Choose where the template should appear: on the first page only or on all pages.', 'foxiz' ),
					'type'     => 'select',
					'options'  => [
						'1' => esc_html__( 'Show on the first page', 'foxiz' ),
						'2' => esc_html__( 'Show on all pages', 'foxiz' ),
					],
					'default'  => '1',
				],
				[
					'id'     => 'section_end_blog_builder',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_blog_posts_per_page',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Posts Per Page', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'          => $prefix . 'posts_per_page',
					'title'       => esc_html__( 'Posts per Page', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select posts per page for the blog. Leave this option blank to set the default.', 'foxiz' ),
					'description' => esc_html__( 'This setting will override on "Dashboard > Settings > Reading > Blog pages show at most" setting. It will also apply to the "or Use Ruby Template for the Post Listing".', 'foxiz' ),
					'type'        => 'text',
					'class'       => 'small-text',
					'validate'    => 'numeric',
					'default'     => '',
				],
				[
					'id'     => 'section_end_blog_posts_per_page',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_blog_template_global',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Global Listing Template', 'foxiz' ),
					'notice' => [
						esc_html__( 'Create a blog listing layout with Ruby Template via Elementor page builder and assign the template shortcode here to create your own layout.', 'foxiz' ),
						esc_html__( 'Ensure "Use WP Global Query" under "Template Builder - Global Query > Query Mode" is set in a block of your template to help the system understand that it is the main query.', 'foxiz' ),
						esc_html__( 'All settings related to predefined layouts (sections below) will not apply if you are using a template.', 'foxiz' ),
					],
					'indent' => true,
				],
				[
					'id'       => $prefix . 'layout',
					'title'    => esc_html__( 'Predefined Layout', 'foxiz' ),
					'subtitle' => esc_html__( 'Select blog listing layout for the blog page.', 'foxiz' ),
					'type'     => 'image_select',
					'options'  => foxiz_config_blog_layout(),
					'default'  => 'classic_1',
				],
				[
					'id'          => $prefix . 'template_global',
					'title'       => esc_html__( 'or Use Ruby Template for the Post Listing', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input a "Ruby Template" shortcode to display as the main listing posts (blog), e.g: [Ruby_E_Template id="1"]', 'foxiz' ),
					'description' => esc_html__( 'This setting will override the "Predefined Layout" above. Leave blank to use the Predefined Layout setting.', 'foxiz' ),
					'type'        => 'textarea',
					'rows'        => 2,
					'placeholder' => '[Ruby_E_Template id="1"]',
					'default'     => '',
				],
				[
					'id'     => 'section_end_global_builder',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_blog_blog_layout',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Post Listing - Columns', 'foxiz' ),
					'subtitle' => esc_html__( 'These settings will only take effect if you select the Predefined layout for displaying the global post listing.', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'       => $prefix . 'columns',
					'title'    => esc_html__( 'Columns on Desktop', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the total number of columns to show per row on desktop devices.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_columns(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'columns_tablet',
					'title'    => esc_html__( 'Columns on Tablet', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the total number of columns to show per row on tablet devices.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_columns(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'columns_mobile',
					'title'    => esc_html__( 'Columns on Mobile', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the total number of columns to show per row on mobile devices.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_columns( [ '0', '1', '2' ] ),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'column_gap',
					'title'    => esc_html__( 'Column Gap', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a spacing between columns.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_column_gap(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_blog_blog_layout',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_blog_sidebar',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Post Listing - Sidebar', 'foxiz' ),
					'subtitle' => esc_html__( 'These settings will only take effect if you select the Predefined layout for displaying the global post listing.', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'       => $prefix . 'sidebar_position',
					'type'     => 'image_select',
					'title'    => esc_html__( 'Sidebar Position', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a sidebar position or disable it for the latest blog section', 'foxiz' ),
					'options'  => foxiz_config_sidebar_position(),
					'default'  => 'default',
				],
				[
					'id'       => $prefix . 'sidebar_name',
					'type'     => 'select',
					'title'    => esc_html__( 'Assign a Sidebar', 'foxiz' ),
					'subtitle' => esc_html__( 'Assign a widget section for the sidebar for the latest blog section if it is enabled.', 'foxiz' ),
					'options'  => foxiz_config_sidebar_name( false ),
					'default'  => 'foxiz_sidebar_default',
				],
				[
					'id'       => $prefix . 'sticky_sidebar',
					'type'     => 'select',
					'title'    => esc_html__( 'Sticky Sidebar', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable sticky sidebar feature. This setting applies to the blog page.', 'foxiz' ),
					'options'  => [
						'0'  => esc_html__( '- Default -', 'foxiz' ),
						'1'  => esc_html__( 'Sticky Sidebar', 'foxiz' ),
						'2'  => esc_html__( 'Sticky Last Widget', 'foxiz' ),
						'-1' => esc_html__( 'Disable', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'     => 'section_end_blog_sidebar',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_blog_design',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Post Listing - Design', 'foxiz' ),
					'notice' => [
						esc_html__( 'These settings will only take effect if you select the Predefined layout for displaying the global post listing.', 'foxiz' ),
						esc_html__( 'The theme\'s default settings are set to use the "Standard Blog Design". However, you can customize these settings using the options below', 'foxiz' ),
					],
					'indent' => true,
				],
				[
					'id'       => $prefix . 'crop_size',
					'title'    => esc_html__( 'Featured Image Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a featured image size to optimize with the columns setting.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_crop_size(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'display_ratio',
					'type'     => 'text',
					'title'    => esc_html__( 'Custom Featured Ratio', 'foxiz' ),
					'subtitle' => esc_html__( 'Input custom ratio percent (height*100/width) for featured image you would like. e.g. 50', 'foxiz' ),
					'default'  => '',
				],
				[
					'id'          => $prefix . 'entry_category',
					'title'       => esc_html__( 'Entry Category', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a layout for the entry category to display in the post listing.', 'foxiz' ),
					'description' => esc_html__( 'The setting will not apply if the selected blog layout does not support the selected entry category.', 'foxiz' ),
					'type'        => 'select',
					'options'     => foxiz_config_extended_entry_category( true ),
					'default'     => '0',
				],
				[
					'id'       => $prefix . 'hide_category',
					'type'     => 'select',
					'title'    => esc_html__( 'Responsive - Hide Entry Category', 'foxiz' ),
					'subtitle' => esc_html__( 'Hide the entry category on tablet and mobile devices.', 'foxiz' ),
					'options'  => [
						'0'      => esc_html__( '- Default -', 'foxiz' ),
						'mobile' => esc_html__( 'On Mobile', 'foxiz' ),
						'tablet' => esc_html__( 'On Tablet', 'foxiz' ),
						'all'    => esc_html__( 'On Tablet & Mobile', 'foxiz' ),
						'-1'     => esc_html__( 'Disable', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'title_tag',
					'title'    => esc_html__( 'Title HTML Tag', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a title HTML tag for the post title.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_heading_tag(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'title_size',
					'title'    => esc_html__( 'Desktop - Title Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (in pixels) for the post title on desktop devices. Leave blank to set it as the default.', 'foxiz' ),
					'type'     => 'text',
					'default'  => '',
				],
				[
					'id'       => $prefix . 'title_size_tablet',
					'title'    => esc_html__( 'Tablet - Title Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (in pixels) for the post title on tablet devices. Leave blank to set it as the default.', 'foxiz' ),
					'type'     => 'text',
					'default'  => '',
				],
				[
					'id'       => $prefix . 'title_size_mobile',
					'title'    => esc_html__( 'Mobile - Title Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (in pixels) for the post title on mobile devices. Leave blank to set it as the default.', 'foxiz' ),
					'type'     => 'text',
					'default'  => '',
				],
				[
					'id'       => $prefix . 'entry_meta_bar',
					'type'     => 'select',
					'title'    => esc_html__( 'Entry Meta Bar', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the entry meta tags you want to show.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_bar(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'entry_meta',
					'type'     => 'select',
					'multi'    => true,
					'title'    => esc_html__( 'Entry Meta Tags', 'foxiz' ),
					'required' => [ $prefix . 'entry_meta_bar', '=', 'custom' ],
					'subtitle' => esc_html__( 'Customize the appearance of the entry meta. Select "Disable" only if you wish to hide the entry meta.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_tags(),
					'default'  => [],
				],
				[
					'id'       => $prefix . 'review',
					'type'     => 'select',
					'title'    => esc_html__( 'Review Meta', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select setting for entry review meta.', 'foxiz' ),
					'options'  => foxiz_config_entry_review( true ),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'review_meta',
					'type'     => 'select',
					'title'    => esc_html__( 'Review Meta Description', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the meta description at the end of the review bar.', 'foxiz' ),
					'options'  => foxiz_config_review_desc_dropdown(),
					'default'  => '0',
				],
				[
					'id'          => $prefix . 'tablet_hide_meta',
					'type'        => 'text',
					'title'       => esc_html__( 'Hide Entry Meta on Tablet', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input the entry meta tags that you want to hide on tablet devices, separate by comma. e.g. avatar, author... Keys include: [avatar, author, date, category, tag, view, comment, update, read, like, bookmark, custom]. Input -1 to re-enable all tags.', 'foxiz' ),
					'placeholder' => esc_html__( 'avatar,author', 'foxiz' ),
					'default'     => '',
				],
				[
					'id'          => $prefix . 'mobile_hide_meta',
					'type'        => 'text',
					'title'       => esc_html__( 'Hide Entry Meta on Mobile', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input the entry meta tags that you want to hide on mobile devices, separate by comma. e.g. avatar, author... Keys include: [avatar, author, date, category, tag, view, comment, update, read, like, bookmark, custom]. Input -1 to re-enable all tags.', 'foxiz' ),
					'placeholder' => esc_html__( 'avatar,author', 'foxiz' ),
					'default'     => '',
				],
				[
					'id'       => $prefix . 'bookmark',
					'type'     => 'select',
					'title'    => esc_html__( 'Bookmark Icon', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the bookmark icon.', 'foxiz' ),
					'options'  => foxiz_config_switch_dropdown(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'entry_format',
					'type'     => 'select',
					'title'    => esc_html__( 'Post Format Icon', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select setting for the post format.', 'foxiz' ),
					'options'  => foxiz_config_entry_format( true ),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'excerpt',
					'type'     => 'select',
					'title'    => esc_html__( 'Excerpt', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select settings for the post excerpt.', 'foxiz' ),
					'options'  => foxiz_config_excerpt_dropdown(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'excerpt_length',
					'type'     => 'text',
					'class'    => 'small-text',
					'validate' => 'numeric',
					'title'    => esc_html__( 'Excerpt - Max Length', 'foxiz' ),
					'required' => [ $prefix . 'excerpt', '=', '1' ],
					'subtitle' => esc_html__( 'select max length of the post excerpt.', 'foxiz' ),
					'desc'     => esc_html__( 'Leave this option blank or set 0 to disable.', 'foxiz' ),
					'default'  => '',
				],
				[
					'id'          => $prefix . 'excerpt_source',
					'title'       => esc_html__( 'Excerpt - Source', 'foxiz' ),
					'subtitle'    => esc_html__( 'Where to get the post excerpt.', 'foxiz' ),
					'description' => esc_html__( 'When you select "use title tagline". if it is empty, it will fallback to the post excerpt or content.', 'foxiz' ),
					'required'    => [ $prefix . 'excerpt', '=', '1' ],
					'type'        => 'select',
					'options'     => foxiz_config_excerpt_source(),
					'default'     => 'tagline',
				],
				[
					'id'       => $prefix . 'hide_excerpt',
					'type'     => 'select',
					'title'    => esc_html__( 'Responsive - Hide Excerpt', 'foxiz' ),
					'subtitle' => esc_html__( 'Hide the post excerpt on tablet and mobile devices.', 'foxiz' ),
					'options'  => [
						'0'      => esc_html__( '- Default -', 'foxiz' ),
						'mobile' => esc_html__( 'On Mobile', 'foxiz' ),
						'tablet' => esc_html__( 'On Tablet', 'foxiz' ),
						'all'    => esc_html__( 'On Tablet & Mobile', 'foxiz' ),
						'-1'     => esc_html__( 'Disable', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'readmore',
					'type'     => 'select',
					'title'    => esc_html__( 'Read More Button', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the read more button.', 'foxiz' ),
					'options'  => foxiz_config_switch_dropdown(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_blog_design',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_blog_pagination',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Post Listing - Pagination', 'foxiz' ),
					'subtitle' => esc_html__( 'These settings will only take effect if you select the Predefined layout for displaying the global post listing.', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'       => $prefix . 'pagination',
					'title'    => esc_html__( 'Pagination Type', 'foxiz' ),
					'subtitle' => esc_html__( 'Select pagination type for the blog.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_pagination(),
					'default'  => 'number',
				],
				[
					'id'     => 'section_end_blog_pagination',
					'type'   => 'section',
					'class'  => 'ruby-section-end no-border',
					'indent' => false,
				],

			],
		];
	}
}

if ( ! function_exists( 'foxiz_register_options_author' ) ) {
	function foxiz_register_options_author() {

		$prefix = 'author_';

		return [
			'id'     => 'foxiz_config_section_author',
			'title'  => esc_html__( 'Author Page', 'foxiz' ),
			'icon'   => 'el el-user',
			'desc'   => esc_html__( 'The settings below apply to the author pages.', 'foxiz' ),
			'fields' => [
				[
					'id'     => 'section_start_author_header',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Author Bio', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'bio',
					'title'    => esc_html__( 'Author Bio', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the display of the author bio on author pages.', 'foxiz' ),
					'type'     => 'switch',
					'default'  => true,
				],
				[
					'id'       => $prefix . 'count',
					'title'    => esc_html__( 'Post Count', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable post count information in author bio.', 'foxiz' ),
					'type'     => 'switch',
					'default'  => true,
				],
				[
					'id'       => $prefix . 'pattern',
					'title'    => esc_html__( 'Background Pattern', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a background pattern for the author header.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_archive_header_bg(),
					'default'  => 'dot',
				],
				[
					'id'     => 'section_end_author_header',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_author_bag',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Verified Tick for Author Name', 'foxiz' ),
					'subtitle' => esc_html__( 'The setting also applies to the author box (at the end of post content) in single posts, if that section is enabled.', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'          => 'author_tick',
					'type'        => 'switch',
					'title'       => esc_html__( 'Verified Tick', 'foxiz' ),
					'subtitle'    => esc_html__( 'This setting applies globally. For individual use, navigate to Users > Edit Profile.', 'foxiz' ),
					'description' => esc_html__( 'The settings will only apply to the Editor role and above. For Contributors, it must be enabled manually via the user profile.', 'foxiz' ),
					'default'     => true,
				],
				[
					'id'     => 'section_end_author_bag',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_author_posts_per_page',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Posts per Page', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'          => $prefix . 'posts_per_page',
					'title'       => esc_html__( 'Posts per Page', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select posts per page for the authors. Leave this option blank to set the default.', 'foxiz' ),
					'description' => esc_html__( 'This setting will override on "Dashboard > Settings > Reading > Blog pages show at most" setting. It will also apply to the "or Use Ruby Template for the Post Listing".', 'foxiz' ),
					'type'        => 'text',
					'validate'    => 'numeric',
					'class'       => 'small-text',
					'default'     => '',
				],
				[
					'id'     => 'section_end_author_posts_per_page',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_author_template_global',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Global Listing Template', 'foxiz' ),
					'notice' => [
						esc_html__( 'Create a blog listing layout with Ruby Template via Elementor page builder and assign the template shortcode here to create your own layout.', 'foxiz' ),
						esc_html__( 'Ensure "Use WP Global Query" under "Template Builder - Global Query > Query Mode" is set in a block of your template to help the system understand that it is the main query.', 'foxiz' ),
						esc_html__( 'All settings related to predefined layouts (sections below) will not apply if you are using a template.', 'foxiz' ),
					],
					'indent' => true,
				],
				[
					'id'       => $prefix . 'layout',
					'title'    => esc_html__( 'Predefined Layout', 'foxiz' ),
					'subtitle' => esc_html__( 'Select blog listing layout for the author page.', 'foxiz' ),
					'type'     => 'image_select',
					'options'  => foxiz_config_blog_layout(),
					'default'  => 'grid_1',
				],
				[
					'id'          => $prefix . 'template_global',
					'title'       => esc_html__( 'or Use Ruby Template for the Post Listing', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input a "Ruby Template" shortcode to display as the main listing posts (blog), e.g: [Ruby_E_Template id="1"]', 'foxiz' ),
					'description' => esc_html__( 'This setting will override the "Predefined Layout" above. Leave blank to use the Predefined Layout setting.', 'foxiz' ),
					'type'        => 'textarea',
					'rows'        => 2,
					'placeholder' => '[Ruby_E_Template id="1"]',
					'default'     => '',
				],
				[
					'id'     => 'section_end_author_template_global',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_author_layout',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Post Listing - Columns', 'foxiz' ),
					'subtitle' => esc_html__( 'These settings will only take effect if you select the Predefined layout for displaying the global post listing.', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'       => $prefix . 'columns',
					'title'    => esc_html__( 'Columns per Row', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the total number of columns to show per row on desktop devices.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_columns(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'columns_tablet',
					'title'    => esc_html__( 'Columns on Tablet', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the total number of columns to show per row on tablet devices.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_columns(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'columns_mobile',
					'title'    => esc_html__( 'Columns on Mobile', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the total number of columns to show per row on mobile devices.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_columns( [ '0', '1', '2' ] ),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'column_gap',
					'title'    => esc_html__( 'Column Gap', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a spacing between columns.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_column_gap(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_author_layout',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_author_sidebar',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Post Listing - Sidebar', 'foxiz' ),
					'subtitle' => esc_html__( 'These settings will only take effect if you select the Predefined layout for displaying the global post listing.', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'       => $prefix . 'sidebar_position',
					'type'     => 'image_select',
					'title'    => esc_html__( 'Sidebar Position', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a sidebar position or disable it for the latest blog section', 'foxiz' ),
					'options'  => foxiz_config_sidebar_position(),
					'default'  => 'none',
				],
				[
					'id'       => $prefix . 'sidebar_name',
					'type'     => 'select',
					'title'    => esc_html__( 'Assign a Sidebar', 'foxiz' ),
					'subtitle' => esc_html__( 'Assign a widget section for the sidebar for the latest blog section if it is enabled.', 'foxiz' ),
					'options'  => foxiz_config_sidebar_name( false ),
					'default'  => 'foxiz_sidebar_default',
				],
				[
					'id'       => $prefix . 'sticky_sidebar',
					'type'     => 'select',
					'title'    => esc_html__( 'Sticky Sidebar', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable sticky sidebar feature. This setting applies to the author pages.', 'foxiz' ),
					'options'  => [
						'0'  => esc_html__( '- Default -', 'foxiz' ),
						'1'  => esc_html__( 'Sticky Sidebar', 'foxiz' ),
						'2'  => esc_html__( 'Sticky Last Widget', 'foxiz' ),
						'-1' => esc_html__( 'Disable', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'     => 'section_end_author_sidebar',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_author_design',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Post Listing - Design', 'foxiz' ),
					'notice' => [
						esc_html__( 'These settings will only take effect if you select the Predefined layout for displaying the global post listing.', 'foxiz' ),
						esc_html__( 'The theme\'s default settings are set to use the "Standard Blog Design". However, you can customize these settings using the options below', 'foxiz' ),
					],
					'indent' => true,
				],
				[
					'id'       => $prefix . 'crop_size',
					'title'    => esc_html__( 'Featured Image Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a featured image size to optimize with the columns setting.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_crop_size(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'display_ratio',
					'type'     => 'text',
					'title'    => esc_html__( 'Custom Featured Ratio', 'foxiz' ),
					'subtitle' => esc_html__( 'Input custom ratio percent (height*100/width) for featured image you would like. e.g. 50', 'foxiz' ),
					'default'  => '',
				],
				[
					'id'          => $prefix . 'entry_category',
					'title'       => esc_html__( 'Entry Category', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a layout for the entry category to display in the post listing.', 'foxiz' ),
					'description' => esc_html__( 'The setting will not apply if the selected blog layout does not support the selected entry category.', 'foxiz' ),
					'type'        => 'select',
					'options'     => foxiz_config_extended_entry_category( true ),
					'default'     => '0',
				],
				[
					'id'       => $prefix . 'hide_category',
					'type'     => 'select',
					'title'    => esc_html__( 'Responsive - Hide Entry Category', 'foxiz' ),
					'subtitle' => esc_html__( 'Hide the entry category on tablet and mobile devices.', 'foxiz' ),
					'options'  => [
						'0'      => esc_html__( '- Default -', 'foxiz' ),
						'mobile' => esc_html__( 'On Mobile', 'foxiz' ),
						'tablet' => esc_html__( 'On Tablet', 'foxiz' ),
						'all'    => esc_html__( 'On Tablet & Mobile', 'foxiz' ),
						'-1'     => esc_html__( 'Disable', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'title_tag',
					'title'    => esc_html__( 'Title HTML Tag', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a title HTML tag for the post title.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_heading_tag(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'title_size',
					'title'    => esc_html__( 'Desktop - Title Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (in pixels) for the post title on desktop devices. Leave blank to set it as the default.', 'foxiz' ),
					'type'     => 'text',
					'default'  => '',
				],
				[
					'id'       => $prefix . 'title_size_tablet',
					'title'    => esc_html__( 'Tablet - Title Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (in pixels) for the post title on tablet devices. Leave blank to set it as the default.', 'foxiz' ),
					'type'     => 'text',
					'default'  => '',
				],
				[
					'id'       => $prefix . 'title_size_mobile',
					'title'    => esc_html__( 'Mobile - Title Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (in pixels) for the post title on mobile devices. Leave blank to set it as the default.', 'foxiz' ),
					'type'     => 'text',
					'default'  => '',
				],
				[
					'id'       => $prefix . 'entry_meta_bar',
					'type'     => 'select',
					'title'    => esc_html__( 'Entry Meta Bar', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the entry meta tags you want to show.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_bar(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'entry_meta',
					'type'     => 'select',
					'multi'    => true,
					'title'    => esc_html__( 'Entry Meta Tags', 'foxiz' ),
					'required' => [ $prefix . 'entry_meta_bar', '=', 'custom' ],
					'subtitle' => esc_html__( 'Customize the appearance of the entry meta. Select "Disable" only if you wish to hide the entry meta.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_tags(),
					'default'  => [],
				],
				[
					'id'       => $prefix . 'review',
					'type'     => 'select',
					'title'    => esc_html__( 'Review Meta', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select setting for entry review meta.', 'foxiz' ),
					'options'  => foxiz_config_entry_review( true ),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'review_meta',
					'type'     => 'select',
					'title'    => esc_html__( 'Review Meta Description', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the meta description at the end of the review bar.', 'foxiz' ),
					'options'  => foxiz_config_review_desc_dropdown(),
					'default'  => '0',
				],
				[
					'id'          => $prefix . 'tablet_hide_meta',
					'type'        => 'text',
					'title'       => esc_html__( 'Hide Entry Meta on Tablet', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input the entry meta tags that you want to hide on tablet devices, separate by comma. e.g. avatar, author... Keys include: [avatar, author, date, category, tag, view, comment, update, read, like, bookmark, custom]. Input -1 to re-enable all tags.', 'foxiz' ),
					'placeholder' => esc_html__( 'avatar,author', 'foxiz' ),
					'default'     => '',
				],
				[
					'id'          => $prefix . 'mobile_hide_meta',
					'type'        => 'text',
					'title'       => esc_html__( 'Hide Entry Meta on Mobile', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input the entry meta tags that you want to hide on mobile devices, separate by comma. e.g. avatar, author... Keys include: [avatar, author, date, category, tag, view, comment, update, read, like, bookmark, custom]. Input -1 to re-enable all tags.', 'foxiz' ),
					'placeholder' => esc_html__( 'avatar,author', 'foxiz' ),
					'default'     => '',
				],
				[
					'id'       => $prefix . 'bookmark',
					'type'     => 'select',
					'title'    => esc_html__( 'Bookmark Icon', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the bookmark icon.', 'foxiz' ),
					'options'  => foxiz_config_switch_dropdown(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'entry_format',
					'type'     => 'select',
					'title'    => esc_html__( 'Post Format Icon', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select setting for the post format.', 'foxiz' ),
					'options'  => foxiz_config_entry_format( true ),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'excerpt',
					'type'     => 'select',
					'title'    => esc_html__( 'Excerpt', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select settings for the post excerpt.', 'foxiz' ),
					'options'  => foxiz_config_excerpt_dropdown(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'excerpt_length',
					'type'     => 'text',
					'class'    => 'small-text',
					'validate' => 'numeric',
					'title'    => esc_html__( 'Excerpt - Max Length', 'foxiz' ),
					'required' => [ $prefix . 'excerpt', '=', '1' ],
					'subtitle' => esc_html__( 'select max length of the post excerpt.', 'foxiz' ),
					'desc'     => esc_html__( 'Leave this option blank or set 0 to disable.', 'foxiz' ),
					'default'  => '',
				],
				[
					'id'          => $prefix . 'excerpt_source',
					'title'       => esc_html__( 'Excerpt - Source', 'foxiz' ),
					'subtitle'    => esc_html__( 'Where to get the post excerpt.', 'foxiz' ),
					'description' => esc_html__( 'When you select "use title tagline". if it is empty, it will fallback to the post excerpt or content.', 'foxiz' ),
					'required'    => [ $prefix . 'excerpt', '=', '1' ],
					'type'        => 'select',
					'options'     => foxiz_config_excerpt_source(),
					'default'     => 'tagline',
				],
				[
					'id'       => $prefix . 'hide_excerpt',
					'type'     => 'select',
					'title'    => esc_html__( 'Responsive - Hide Excerpt', 'foxiz' ),
					'subtitle' => esc_html__( 'Hide the post excerpt on tablet and mobile devices.', 'foxiz' ),
					'options'  => [
						'0'      => esc_html__( '- Default -', 'foxiz' ),
						'mobile' => esc_html__( 'On Mobile', 'foxiz' ),
						'tablet' => esc_html__( 'On Tablet', 'foxiz' ),
						'all'    => esc_html__( 'On Tablet & Mobile', 'foxiz' ),
						'-1'     => esc_html__( 'Disable', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'readmore',
					'type'     => 'select',
					'title'    => esc_html__( 'Read More Button', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the read more button.', 'foxiz' ),
					'options'  => foxiz_config_switch_dropdown(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_author_design',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_author_pagination',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Post Listing - Pagination', 'foxiz' ),
					'subtitle' => esc_html__( 'These settings will only take effect if you select the Predefined layout for displaying the global post listing.', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'       => $prefix . 'pagination',
					'title'    => esc_html__( 'Pagination Type', 'foxiz' ),
					'subtitle' => esc_html__( 'Select pagination type for the author pages.', 'foxiz' ),
					'type'     => 'select',
					'options'  => [
						'number' => esc_html__( 'Numeric', 'foxiz' ),
						'simple' => esc_html__( 'Simple', 'foxiz' ),
					],
					'default'  => 'number',
				],
				[
					'id'     => 'section_end_author_pagination',
					'type'   => 'section',
					'class'  => 'ruby-section-end no-border',
					'indent' => false,
				],
			],
		];
	}
}

if ( ! function_exists( 'foxiz_register_options_tag' ) ) {
	function foxiz_register_options_tag() {

		return [
			'id'     => 'foxiz_config_section_tag',
			'title'  => esc_html__( 'Tag Page', 'foxiz' ),
			'icon'   => 'el el-tags',
			'desc'   => esc_html__( 'The settings below allow you to create custom templates for the post tags. If no custom templates are set, the predefined post listing layout settings from the archive panel will apply to the tag page.', 'foxiz' ),
			'fields' => [
				[
					'id'       => 'section_start_tag_header',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Tag Header', 'foxiz' ),
					'subtitle' => esc_html__( 'Please ensure that you construct the header template or add an H1 tag somewhere if you choose to disable the header to avoid SEO issues.', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'       => 'tag_header',
					'title'    => esc_html__( 'Tag Header', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or choose a style for the tag header.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_archive_header( true ),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_tag_header',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],

				[
					'id'     => 'section_start_tag_template',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Top Template Builder', 'foxiz' ),
					'notice' => [
						esc_html__( 'These settings enable you to create a custom featured posts area at the top of the tag page with ease.', 'foxiz' ),
						esc_html__( 'Please note that these settings will be overridden by the "Top Section" settings in the individual tag settings panel.', 'foxiz' ),
					],
					'indent' => true,
				],
				[
					'id'          => 'tag_template',
					'title'       => esc_html__( 'Template Shortcode', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input a "Ruby Template" shortcode to embed it after the tag header, e.g: [Ruby_E_Template id="1"]', 'foxiz' ),
					'type'        => 'textarea',
					'placeholder' => '[Ruby_E_Template id="1"]',
					'rows'        => 2,
					'default'     => '',
				],
				[
					'id'       => 'tag_template_display',
					'title'    => esc_html__( 'Display Condition', 'foxiz' ),
					'subtitle' => esc_html__( 'Choose where the template should appear: on the first page only or on all pages.', 'foxiz' ),
					'type'     => 'select',
					'options'  => [
						'1' => esc_html__( 'Show on the first page', 'foxiz' ),
						'2' => esc_html__( 'Show on all pages', 'foxiz' ),
					],
					'default'  => '1',
				],
				[
					'id'     => 'section_end_tag_template',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],

				[
					'id'     => 'section_start_tag_posts_per_page',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Posts per Page', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'          => 'tag_posts_per_page',
					'title'       => esc_html__( 'Posts per Page', 'foxiz' ),
					'subtitle'    => esc_html__( 'Enter the number of posts to display per page for the tag.', 'foxiz' ),
					'description' => esc_html__( 'This setting will apply if the posts per page for the archive is left empty.', 'foxiz' ),
					'type'        => 'text',
					'validate'    => 'numeric',
					'class'       => 'small-text',
					'default'     => '',
				],
				[
					'id'     => 'section_end_tag_posts_per_page',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_tag_template_global',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Global Listing Template', 'foxiz' ),
					'notice' => [
						esc_html__( 'Create a blog listing layout with Ruby Template via Elementor page builder and assign the template shortcode here to create your own layout.', 'foxiz' ),
						esc_html__( 'Ensure "Use WP Global Query" under "Template Builder - Global Query > Query Mode" is set in a block of your template to help the system understand that it is the main query.', 'foxiz' ),
					],
					'indent' => true,
				],
				[
					'id'          => 'tag_template_global',
					'title'       => esc_html__( 'Use Ruby Template for the Post Listing', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input a "Ruby Template" shortcode to display as the main listing posts (blog) for the tag. e.g: [Ruby_E_Template id="1"]', 'foxiz' ),
					'description' => esc_html__( 'Leave blank to use default post listing settings from the "Archives" panel.', 'foxiz' ),
					'type'        => 'textarea',
					'rows'        => 2,
					'placeholder' => '[Ruby_E_Template id="1"]',
					'default'     => '',
				],
				[
					'id'     => 'section_end_tag_template_global',
					'type'   => 'section',
					'class'  => 'ruby-section-end no-border',
					'indent' => false,
				],
			],
		];
	}
}

if ( ! function_exists( 'foxiz_register_options_archive' ) ) {
	function foxiz_register_options_archive() {

		$prefix = 'archive_';

		return [
			'id'     => 'foxiz_config_section_archive',
			'title'  => esc_html__( 'Archives', 'foxiz' ),
			'icon'   => 'el el-inbox-box',
			'desc'   => esc_html__( 'The settings below are considered as overall settings for post tags, taxonomies, and archives. They may be overridden by other settings.', 'foxiz' ),
			'fields' => [
				[
					'id'       => 'section_start_archive_header',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Archive Header', 'foxiz' ),
					'subtitle' => esc_html__( 'Please ensure that you construct the header template or add an H1 tag somewhere if you choose to disable the header to avoid SEO issues.', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'          => $prefix . 'no_prefix',
					'title'       => esc_html__( 'Archive Title Prefix', 'foxiz' ),
					'subtitle'    => esc_html__( 'Enable or disable prefix for archive and tag titles.', 'foxiz' ),
					'description' => esc_html__( 'This setting applies to all tag, taxonomy, and archive titles.', 'foxiz' ),
					'type'        => 'select',
					'options'     => [
						'0' => esc_html__( '- Default -', 'foxiz' ),
						'1' => esc_html__( 'No Prefix', 'foxiz' ),
					],
					'default'     => '0',
				],
				[
					'id'       => $prefix . 'archive_header',
					'title'    => esc_html__( 'Archive Header', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select a style for the archive headers.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_archive_header(),
					'default'  => '1',
				],
				[
					'id'       => $prefix . 'pattern',
					'title'    => esc_html__( 'Background Pattern', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a background pattern for the archive header.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_archive_header_bg(),
					'default'  => 'dot',
				],
				[
					'id'     => 'section_end_archive_header',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_archive_posts_per_page',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Posts per Page', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'          => $prefix . 'posts_per_page',
					'title'       => esc_html__( 'Archive - Posts per Page', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input posts per page for the archives. Leave this option blank to set the default.', 'foxiz' ),
					'description' => esc_html__( 'Global settings in "Settings > Reading > Blog pages show at most" will apply if it is empty.', 'foxiz' ),
					'type'        => 'text',
					'validate'    => 'numeric',
					'class'       => 'small-text',
					'default'     => '',
				],
				[
					'id'     => 'section_end_archive_posts_per_page',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_archive_template_global',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Global Listing Template', 'foxiz' ),
					'notice' => [
						esc_html__( 'The AJAX methods in the builder pagination settings of the global query block are available only for the tags page. Numeric pagination will be used as a fallback option for other archive pages.', 'foxiz' ),
						esc_html__( 'Create a blog listing layout with Ruby Template via Elementor page builder and assign the template shortcode here to create your own layout.', 'foxiz' ),
						esc_html__( 'Ensure "Use WP Global Query" under "Template Builder - Global Query > Query Mode" is set in a block of your template to help the system understand that it is the main query.', 'foxiz' ),
						esc_html__( 'All settings related to predefined layouts (sections below) will not apply if you are using a template.', 'foxiz' ),
					],
					'indent' => true,
				],
				[
					'id'       => $prefix . 'layout',
					'title'    => esc_html__( 'Predefined Layout', 'foxiz' ),
					'subtitle' => esc_html__( 'Select blog listing layout for the archive pages.', 'foxiz' ),
					'type'     => 'image_select',
					'options'  => foxiz_config_blog_layout(),
					'default'  => 'grid_1',
				],
				[
					'id'          => $prefix . 'template_global',
					'title'       => esc_html__( 'or Use Ruby Template for the Post Listing', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input a "Ruby Template" shortcode to display as the main listing posts (blog), e.g: [Ruby_E_Template id="1"]', 'foxiz' ),
					'description' => esc_html__( 'This setting will override the "Predefined Layout" above. Leave blank to use the Predefined Layout setting.', 'foxiz' ),
					'type'        => 'textarea',
					'rows'        => 2,
					'placeholder' => '[Ruby_E_Template id="1"]',
					'default'     => '',
				],
				[
					'id'     => 'section_end_archive_template_global',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_archive_blog_layout',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Post Listing - Columns', 'foxiz' ),
					'subtitle' => esc_html__( 'These settings will only take effect if you select the Predefined layout for displaying the global post listing.', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'       => $prefix . 'columns',
					'title'    => esc_html__( 'Columns on Desktop', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the total number of columns to show per row on desktop devices.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_columns(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'columns_tablet',
					'title'    => esc_html__( 'Columns on Tablet', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the total number of columns to show per row on tablet devices.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_columns(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'columns_mobile',
					'title'    => esc_html__( 'Columns on Mobile', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the total number of columns to show per row on mobile devices.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_columns( [ '0', '1', '2' ] ),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'column_gap',
					'title'    => esc_html__( 'Column Gap', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a spacing between columns.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_column_gap(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_archive_blog_layout',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_archive_sidebar',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Post Listing - Sidebar', 'foxiz' ),
					'subtitle' => esc_html__( 'These settings will only take effect if you select the Predefined layout for displaying the global post listing.', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'       => $prefix . 'sidebar_position',
					'type'     => 'image_select',
					'title'    => esc_html__( 'Sidebar Position', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a sidebar position or disable it for the latest blog section', 'foxiz' ),
					'options'  => foxiz_config_sidebar_position(),
					'default'  => 'none',
				],
				[
					'id'       => $prefix . 'sidebar_name',
					'type'     => 'select',
					'title'    => esc_html__( 'Assign a Sidebar', 'foxiz' ),
					'subtitle' => esc_html__( 'Assign a widget section for the sidebar for the latest blog section if it is enabled.', 'foxiz' ),
					'options'  => foxiz_config_sidebar_name( false ),
					'default'  => 'foxiz_sidebar_default',
				],
				[
					'id'       => $prefix . 'sticky_sidebar',
					'type'     => 'select',
					'title'    => esc_html__( 'Sticky Sidebar', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable sticky sidebar feature. This setting applies to the archive pages.', 'foxiz' ),
					'options'  => [
						'0'  => esc_html__( '- Default -', 'foxiz' ),
						'1'  => esc_html__( 'Sticky Sidebar', 'foxiz' ),
						'2'  => esc_html__( 'Sticky Last Widget', 'foxiz' ),
						'-1' => esc_html__( 'Disable', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'     => 'section_end_archive_sidebar',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_archive_design',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Post Listing - Design', 'foxiz' ),
					'notice' => [
						esc_html__( 'These settings will only take effect if you select the Predefined layout for displaying the global post listing.', 'foxiz' ),
						esc_html__( 'The theme\'s default settings are set to use the "Standard Blog Design". However, you can customize these settings using the options below', 'foxiz' ),
					],
					'indent' => true,
				],
				[
					'id'       => $prefix . 'crop_size',
					'title'    => esc_html__( 'Featured Image Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a featured image size to optimize with the columns setting.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_crop_size(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'display_ratio',
					'type'     => 'text',
					'title'    => esc_html__( 'Custom Featured Ratio', 'foxiz' ),
					'subtitle' => esc_html__( 'Input custom ratio percent (height*100/width) for featured image you would like. e.g. 50', 'foxiz' ),
					'default'  => '',
				],
				[
					'id'          => $prefix . 'entry_category',
					'title'       => esc_html__( 'Entry Category', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a layout for the entry category to display in the post listing.', 'foxiz' ),
					'description' => esc_html__( 'The setting will not apply if the selected blog layout does not support the selected entry category.', 'foxiz' ),
					'type'        => 'select',
					'options'     => foxiz_config_extended_entry_category( true ),
					'default'     => '0',
				],
				[
					'id'       => $prefix . 'hide_category',
					'type'     => 'select',
					'title'    => esc_html__( 'Responsive - Hide Entry Category', 'foxiz' ),
					'subtitle' => esc_html__( 'Hide the entry category on tablet and mobile devices.', 'foxiz' ),
					'options'  => [
						'0'      => esc_html__( '- Default -', 'foxiz' ),
						'mobile' => esc_html__( 'On Mobile', 'foxiz' ),
						'tablet' => esc_html__( 'On Tablet', 'foxiz' ),
						'all'    => esc_html__( 'On Tablet & Mobile', 'foxiz' ),
						'-1'     => esc_html__( 'Disable', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'title_tag',
					'title'    => esc_html__( 'Title HTML Tag', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a title HTML tag for the post title.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_heading_tag(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'title_size',
					'title'    => esc_html__( 'Desktop - Title Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (in pixels) for the post title on desktop devices. Leave blank to set it as the default.', 'foxiz' ),
					'type'     => 'text',
					'default'  => '',
				],
				[
					'id'       => $prefix . 'title_size_tablet',
					'title'    => esc_html__( 'Tablet - Title Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (in pixels) for the post title on tablet devices. Leave blank to set it as the default.', 'foxiz' ),
					'type'     => 'text',
					'default'  => '',
				],
				[
					'id'       => $prefix . 'title_size_mobile',
					'title'    => esc_html__( 'Mobile - Title Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (in pixels) for the post title on mobile devices. Leave blank to set it as the default.', 'foxiz' ),
					'type'     => 'text',
					'default'  => '',
				],
				[
					'id'       => $prefix . 'entry_meta_bar',
					'type'     => 'select',
					'title'    => esc_html__( 'Entry Meta Bar', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the entry meta tags you want to show.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_bar(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'entry_meta',
					'type'     => 'select',
					'multi'    => true,
					'title'    => esc_html__( 'Entry Meta Tags', 'foxiz' ),
					'required' => [ $prefix . 'entry_meta_bar', '=', 'custom' ],
					'subtitle' => esc_html__( 'Customize the appearance of the entry meta. Select "Disable" only if you wish to hide the entry meta.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_tags(),
					'default'  => [],
				],
				[
					'id'       => $prefix . 'review',
					'type'     => 'select',
					'title'    => esc_html__( 'Review Meta', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select setting for entry review meta.', 'foxiz' ),
					'options'  => foxiz_config_entry_review( true ),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'review_meta',
					'type'     => 'select',
					'title'    => esc_html__( 'Review Meta Description', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the meta description at the end of the review bar.', 'foxiz' ),
					'options'  => foxiz_config_review_desc_dropdown(),
					'default'  => '0',
				],
				[
					'id'          => $prefix . 'tablet_hide_meta',
					'type'        => 'text',
					'title'       => esc_html__( 'Hide Entry Meta on Tablet', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input the entry meta tags that you want to hide on tablet devices, separate by comma. e.g. avatar, author... Keys include: [avatar, author, date, category, tag, view, comment, update, read, like, bookmark, custom]. Input -1 to re-enable all tags.', 'foxiz' ),
					'placeholder' => esc_html__( 'avatar,author', 'foxiz' ),
					'default'     => '',
				],
				[
					'id'          => $prefix . 'mobile_hide_meta',
					'type'        => 'text',
					'title'       => esc_html__( 'Hide Entry Meta on Mobile', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input the entry meta tags that you want to hide on mobile devices, separate by comma. e.g. avatar, author... Keys include: [avatar, author, date, category, tag, view, comment, update, read, like, bookmark, custom]. Input -1 to re-enable all tags.', 'foxiz' ),
					'placeholder' => esc_html__( 'avatar,author', 'foxiz' ),
					'default'     => '',
				],
				[
					'id'       => $prefix . 'bookmark',
					'type'     => 'select',
					'title'    => esc_html__( 'Bookmark Icon', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the bookmark icon.', 'foxiz' ),
					'options'  => foxiz_config_switch_dropdown(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'entry_format',
					'type'     => 'select',
					'title'    => esc_html__( 'Post Format Icon', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select setting for the post format.', 'foxiz' ),
					'options'  => foxiz_config_entry_format( true ),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'excerpt',
					'type'     => 'select',
					'title'    => esc_html__( 'Excerpt', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select settings for the post excerpt.', 'foxiz' ),
					'options'  => foxiz_config_excerpt_dropdown(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'excerpt_length',
					'type'     => 'text',
					'class'    => 'small-text',
					'validate' => 'numeric',
					'title'    => esc_html__( 'Excerpt - Max Length', 'foxiz' ),
					'required' => [ $prefix . 'excerpt', '=', '1' ],
					'subtitle' => esc_html__( 'select max length of the post excerpt.', 'foxiz' ),
					'desc'     => esc_html__( 'Leave this option blank or set 0 to disable.', 'foxiz' ),
					'default'  => '',
				],
				[
					'id'          => $prefix . 'excerpt_source',
					'title'       => esc_html__( 'Excerpt - Source', 'foxiz' ),
					'subtitle'    => esc_html__( 'Where to get the post excerpt.', 'foxiz' ),
					'description' => esc_html__( 'When you select "use title tagline". if it is empty, it will fallback to the post excerpt or content.', 'foxiz' ),
					'required'    => [ $prefix . 'excerpt', '=', '1' ],
					'type'        => 'select',
					'options'     => foxiz_config_excerpt_source(),
					'default'     => 'tagline',
				],
				[
					'id'       => $prefix . 'hide_excerpt',
					'type'     => 'select',
					'title'    => esc_html__( 'Responsive - Hide Excerpt', 'foxiz' ),
					'subtitle' => esc_html__( 'Hide the post excerpt on tablet and mobile devices.', 'foxiz' ),
					'options'  => [
						'0'      => esc_html__( '- Default -', 'foxiz' ),
						'mobile' => esc_html__( 'On Mobile', 'foxiz' ),
						'tablet' => esc_html__( 'On Tablet', 'foxiz' ),
						'all'    => esc_html__( 'On Tablet & Mobile', 'foxiz' ),
						'-1'     => esc_html__( 'Disable', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'readmore',
					'type'     => 'select',
					'title'    => esc_html__( 'Read More Button', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the read more button.', 'foxiz' ),
					'options'  => foxiz_config_switch_dropdown(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_archive_design',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_archive_pagination',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Post Listing - Pagination', 'foxiz' ),
					'subtitle' => esc_html__( 'These settings will only take effect if you select the Predefined layout for displaying the global post listing.', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'       => $prefix . 'pagination',
					'title'    => esc_html__( 'Pagination Type', 'foxiz' ),
					'subtitle' => esc_html__( 'Select pagination type for the archive pages.', 'foxiz' ),
					'type'     => 'select',
					'options'  => [
						'number' => esc_html__( 'Numeric', 'foxiz' ),
						'simple' => esc_html__( 'Simple', 'foxiz' ),
					],
					'default'  => 'number',
				],
				[
					'id'     => 'section_end_archive_pagination',
					'type'   => 'section',
					'class'  => 'ruby-section-end no-border',
					'indent' => false,
				],
			],
		];
	}
}

if ( ! function_exists( 'foxiz_register_options_search' ) ) {
	function foxiz_register_options_search() {

		$prefix = 'search_';

		return [
			'id'     => 'foxiz_config_section_search',
			'title'  => esc_html__( 'Search Page', 'foxiz' ),
			'icon'   => 'el el-search',
			'desc'   => esc_html__( 'The settings below apply to the search page.', 'foxiz' ),
			'fields' => [
				[
					'id'     => 'section_start_disallow_types',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Disallow Post Types', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'          => $prefix . 'type_disallow',
					'type'        => 'textarea',
					'title'       => esc_html__( 'Global Disallow Post Types', 'foxiz' ),
					'subtitle'    => esc_html__( 'The search page will not display any results for post types listed in this section. Prevent non-allowed post types via the GET method.', 'foxiz' ),
					'description' => esc_html__( 'Enter multiple post_type keys, separated by commas. Leave blank for unrestricted access to any post types.', 'foxiz' ),
					'placeholder' => 'page, attachment',
					'default'     => 'page, attachment, e-landing-page',
					'rows'        => 2,
				],
				[
					'id'     => 'section_end_search_disallow_types',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_search_filter',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Search Filters', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'          => $prefix . 'post_types',
					'type'        => 'textarea',
					'title'       => esc_html__( 'Include Post Types', 'foxiz' ),
					'subtitle'    => esc_html__( 'Specify all post types you want to display on the search result page using the post_types key. This setting will be overridden by the post_type via GET method.', 'foxiz' ),
					'description' => esc_html__( 'Enter multiple post_type keys, separated by commas. Leave blank to allow any post types.', 'foxiz' ),
					'placeholder' => 'post, podcast',
					'default'     => 'post, podcast',
					'rows'        => 2,
				],
				[
					'id'     => 'section_end_search_filter',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_search_site_header',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Site Header', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'header_style',
					'type'     => 'select',
					'title'    => esc_html__( 'Header Layout', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a website header layout for the search page.', 'foxiz' ),
					'options'  => foxiz_config_header_style( true, true ),
					'default'  => '0',
				],
				[
					'id'          => $prefix . 'header_template',
					'type'        => 'textarea',
					'title'       => esc_html__( 'Or Use Ruby Template for Site Header', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input a Ruby Template shortcode for displaying as the website header for the search page.', 'foxiz' ),
					'description' => esc_html__( 'This setting will override all "Header Layout" settings. Leave it blank to disable.', 'foxiz' ),
					'placeholder' => esc_html__( '[Ruby_E_Template id="1"]', 'foxiz' ),
					'rows'        => 2,
					'default'     => '',
				],
				[
					'id'          => $prefix . 'nav_style',
					'type'        => 'select',
					'title'       => esc_html__( 'Navigation Bar Style', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select navigation bar style for the site header in the search page.', 'foxiz' ),
					'description' => esc_html__( 'This setting will apply only to pre-defined headers: 1, 2, 3 and 5.', 'foxiz' ),
					'options'     => [
						'0'        => esc_html__( '- Default -', 'foxiz' ),
						'shadow'   => esc_html__( 'Shadow', 'foxiz' ),
						'border'   => esc_html__( 'Bottom Border', 'foxiz' ),
						'd-border' => esc_html__( 'Dark Bottom Border', 'foxiz' ),
						'none'     => esc_html__( 'None', 'foxiz' ),
					],
					'default'     => '0',
				],
				[
					'id'     => 'section_end_search_site_header',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_search_header',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Search Header', 'foxiz' ),
					'notice' => [
						esc_html__( 'This section will display the search form and search heading, including keywords and the total number of results.', 'foxiz' ),
						esc_html__( 'Recommended: Add the "Foxiz - Search Posts" block to the top template if using templates for the search page to ensure the search form always appears when no results are found.', 'foxiz' ),
					],
					'indent' => true,
				],
				[
					'id'          => $prefix . 'header',
					'title'       => esc_html__( 'Search Header Layout', 'foxiz' ),
					'subtitle'    => esc_html__( 'Enable or disable the search header and search form.', 'foxiz' ),
					'description' => esc_html__( 'Selecting "Use Top Template" will disable the default header. You can build your own search header, including the search form, via the Ruby Template.', 'foxiz' ),
					'type'        => 'select',
					'options'     => [
						'0'       => esc_html__( '- Default -', 'foxiz' ),
						'wrapper' => esc_html__( 'Wrapper', 'foxiz' ),
						'none'    => esc_html__( 'Use Top Template', 'foxiz' ),
					],
					'default'     => '0',
				],
				[
					'id'          => $prefix . 'top_template',
					'type'        => 'textarea',
					'title'       => esc_html__( 'Top Template Shortcode', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input a Ruby Template shortcode for displaying as the search header.', 'foxiz' ),
					'description' => esc_html__( 'This section is useful if you want to build the header, including the search form, archive title, and description, using Ruby Template.', 'foxiz' ),
					'placeholder' => esc_html__( '[Ruby_E_Template id="1"]', 'foxiz' ),
					'rows'        => 2,
					'default'     => '',
				],
				[
					'id'          => $prefix . 'header_background',
					'type'        => 'background',
					'transparent' => false,
					'title'       => esc_html__( 'Header Background', 'foxiz' ),
					'subtitle'    => esc_html__( 'Upload a background image for the search header.', 'foxiz' ),
					'description' => esc_html__( 'This setting applies only to the default search header.', 'foxiz' ),
					'default'     => [
						'background-color'      => '',
						'background-size'       => 'cover',
						'background-attachment' => 'scroll',
						'background-position'   => 'center center',
						'background-repeat'     => 'no-repeat',
					],
				],
				[
					'id'          => 'dark_' . $prefix . 'header_background',
					'type'        => 'background',
					'transparent' => false,
					'title'       => esc_html__( 'Dark Mode - Header Background', 'foxiz' ),
					'subtitle'    => esc_html__( 'Upload a background image for the search header in dark mode.', 'foxiz' ),
					'default'     => [
						'background-color'      => '',
						'background-size'       => 'cover',
						'background-attachment' => 'scroll',
						'background-position'   => 'center center',
						'background-repeat'     => 'no-repeat',
					],
				],
				[
					'id'          => $prefix . 'header_scheme',
					'type'        => 'select',
					'transparent' => false,
					'title'       => esc_html__( 'Text Color Scheme', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a text color scheme for the mega menus to suit with the background color.', 'foxiz' ),
					'options'     => [
						'0' => esc_html__( 'Default (Dark Text)', 'foxiz' ),
						'1' => esc_html__( 'Light Text', 'foxiz' ),
					],
					'default'     => '0',
				],
				[
					'id'     => 'section_end_search_header',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_search_posts_per_page',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Posts per Page', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'posts_per_page',
					'title'    => esc_html__( 'Posts per Page', 'foxiz' ),
					'subtitle' => esc_html__( 'Select posts per page for the search result listing. Leave this option blank to set the default.', 'foxiz' ),
					'type'     => 'text',
					'class'    => 'small-text',
					'validate' => 'numeric',
					'default'  => '',
				],
				[
					'id'     => 'section_end_search_posts_per_page',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_search_template_global',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Global Listing Template', 'foxiz' ),
					'notice' => [
						esc_html__( 'Create a blog listing layout with Ruby Template via Elementor page builder and assign the template shortcode here to create your own layout.', 'foxiz' ),
						esc_html__( 'Ensure "Use WP Global Query" under "Template Builder - Global Query > Query Mode" is set in a block of your template to help the system understand that it is the main query.', 'foxiz' ),
						esc_html__( 'All settings related to predefined layouts (sections below) will not apply if you are using a template.', 'foxiz' ),
						esc_html__( 'If you want to build the search header (including search form and title...), Consider using the "Top Template Shortcode" setting above to avoid a blank header if there are no results for the search.', 'foxiz' ),
					],
					'indent' => true,
				],
				[
					'id'       => $prefix . 'layout',
					'title'    => esc_html__( 'Predefined Layout', 'foxiz' ),
					'subtitle' => esc_html__( 'Select blog listing layout for the search results.', 'foxiz' ),
					'type'     => 'image_select',
					'options'  => foxiz_config_blog_layout(),
					'default'  => 'grid_small_1',
				],
				[
					'id'          => $prefix . 'template_global',
					'title'       => esc_html__( 'or Use Ruby Template for the Post Listing', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input a "Ruby Template" shortcode to display as the main listing posts (blog), e.g: [Ruby_E_Template id="1"]', 'foxiz' ),
					'description' => esc_html__( 'This setting will override the "Predefined Layout" above. Leave blank to use the Predefined Layout setting.', 'foxiz' ),
					'type'        => 'textarea',
					'rows'        => 2,
					'placeholder' => '[Ruby_E_Template id="1"]',
					'default'     => '',
				],
				[
					'id'     => 'section_end_search_template_global',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_search_layout',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Post Listing - Columns', 'foxiz' ),
					'subtitle' => esc_html__( 'These settings will only take effect if you select the Predefined layout for displaying the global post listing.', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'       => $prefix . 'columns',
					'title'    => esc_html__( 'Columns on Desktop', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the total number of columns to show per row on desktop devices.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_columns(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'columns_tablet',
					'title'    => esc_html__( 'Columns on Tablet', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the total number of columns to show per row on tablet devices.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_columns(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'columns_mobile',
					'title'    => esc_html__( 'Columns on Mobile', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the total number of columns to show per row on mobile devices.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_columns( [ '0', '1', '2' ] ),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'column_gap',
					'title'    => esc_html__( 'Column Gap', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a spacing between columns.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_column_gap(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_search_layout',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_search_sidebar',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Post Listing - Sidebar', 'foxiz' ),
					'subtitle' => esc_html__( 'These settings will only take effect if you select the Predefined layout for displaying the global post listing.', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'       => $prefix . 'sidebar_position',
					'type'     => 'image_select',
					'title'    => esc_html__( 'Sidebar Position', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a sidebar position or disable it for the search result listing.', 'foxiz' ),
					'options'  => foxiz_config_sidebar_position(),
					'default'  => 'none',
				],
				[
					'id'       => $prefix . 'sidebar_name',
					'type'     => 'select',
					'title'    => esc_html__( 'Assign a Sidebar', 'foxiz' ),
					'subtitle' => esc_html__( 'Assign a widget section for the sidebar for the latest blog section if it is enabled.', 'foxiz' ),
					'options'  => foxiz_config_sidebar_name( false ),
					'default'  => 'foxiz_sidebar_default',
				],
				[
					'id'       => $prefix . 'sticky_sidebar',
					'type'     => 'select',
					'title'    => esc_html__( 'Sticky Sidebar', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable sticky sidebar feature. This setting applies to the search pages.', 'foxiz' ),
					'options'  => [
						'0'  => esc_html__( '- Default -', 'foxiz' ),
						'1'  => esc_html__( 'Sticky Sidebar', 'foxiz' ),
						'2'  => esc_html__( 'Sticky Last Widget', 'foxiz' ),
						'-1' => esc_html__( 'Disable', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'     => 'section_end_search_sidebar',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_search_design',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Post Listing - Design', 'foxiz' ),
					'notice' => [
						esc_html__( 'These settings will only take effect if you select the Predefined layout for displaying the global post listing.', 'foxiz' ),
						esc_html__( 'The theme\'s default settings are set to use the "Standard Blog Design". However, you can customize these settings using the options below', 'foxiz' ),
					],
					'indent' => true,
				],
				[
					'id'       => $prefix . 'crop_size',
					'title'    => esc_html__( 'Featured Image Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a featured image size to optimize with the columns setting.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_crop_size(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'display_ratio',
					'type'     => 'text',
					'title'    => esc_html__( 'Custom Featured Ratio', 'foxiz' ),
					'subtitle' => esc_html__( 'Input custom ratio percent (height*100/width) for featured image you would like. e.g. 50', 'foxiz' ),
					'default'  => '',
				],
				[
					'id'          => $prefix . 'entry_category',
					'title'       => esc_html__( 'Entry Category', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a layout for the entry category to display in the post listing.', 'foxiz' ),
					'description' => esc_html__( 'The setting will not apply if the selected blog layout does not support the selected entry category.', 'foxiz' ),
					'type'        => 'select',
					'options'     => foxiz_config_extended_entry_category( true ),
					'default'     => '0',
				],
				[
					'id'       => $prefix . 'hide_category',
					'type'     => 'select',
					'title'    => esc_html__( 'Responsive - Hide Entry Category', 'foxiz' ),
					'subtitle' => esc_html__( 'Hide the entry category on tablet and mobile devices.', 'foxiz' ),
					'options'  => [
						'0'      => esc_html__( '- Default -', 'foxiz' ),
						'mobile' => esc_html__( 'On Mobile', 'foxiz' ),
						'tablet' => esc_html__( 'On Tablet', 'foxiz' ),
						'all'    => esc_html__( 'On Tablet & Mobile', 'foxiz' ),
						'-1'     => esc_html__( 'Disable', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'title_tag',
					'title'    => esc_html__( 'Title HTML Tag', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a title HTML tag for the post title.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_heading_tag(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'title_size',
					'title'    => esc_html__( 'Desktop - Title Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (in pixels) for the post title on desktop devices. Leave blank to set it as the default.', 'foxiz' ),
					'type'     => 'text',
					'default'  => '',
				],
				[
					'id'       => $prefix . 'title_size_tablet',
					'title'    => esc_html__( 'Tablet - Title Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (in pixels) for the post title on tablet devices. Leave blank to set it as the default.', 'foxiz' ),
					'type'     => 'text',
					'default'  => '',
				],
				[
					'id'       => $prefix . 'title_size_mobile',
					'title'    => esc_html__( 'Mobile - Title Font Size', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a font size (in pixels) for the post title on mobile devices. Leave blank to set it as the default.', 'foxiz' ),
					'type'     => 'text',
					'default'  => '',
				],
				[
					'id'       => $prefix . 'entry_meta_bar',
					'type'     => 'select',
					'title'    => esc_html__( 'Entry Meta Bar', 'foxiz' ),
					'subtitle' => esc_html__( 'Select the entry meta tags you want to show.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_bar(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'entry_meta',
					'type'     => 'select',
					'multi'    => true,
					'title'    => esc_html__( 'Entry Meta Tags', 'foxiz' ),
					'required' => [ $prefix . 'entry_meta_bar', '=', 'custom' ],
					'subtitle' => esc_html__( 'Customize the appearance of the entry meta. Select "Disable" only if you wish to hide the entry meta.', 'foxiz' ),
					'options'  => foxiz_config_entry_meta_tags(),
					'default'  => [],
				],
				[
					'id'       => $prefix . 'review',
					'type'     => 'select',
					'title'    => esc_html__( 'Review Meta', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select setting for entry review meta.', 'foxiz' ),
					'options'  => foxiz_config_entry_review( true ),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'review_meta',
					'type'     => 'select',
					'title'    => esc_html__( 'Review Meta Description', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the meta description at the end of the review bar.', 'foxiz' ),
					'options'  => foxiz_config_review_desc_dropdown(),
					'default'  => '0',
				],
				[
					'id'          => $prefix . 'tablet_hide_meta',
					'type'        => 'text',
					'title'       => esc_html__( 'Hide Entry Meta on Tablet', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input the entry meta tags that you want to hide on tablet devices, separate by comma. e.g. avatar, author... Keys include: [avatar, author, date, category, tag, view, comment, update, read, like, bookmark, custom]. Input -1 to re-enable all tags.', 'foxiz' ),
					'placeholder' => esc_html__( 'avatar,author', 'foxiz' ),
					'default'     => '',
				],
				[
					'id'          => $prefix . 'mobile_hide_meta',
					'type'        => 'text',
					'title'       => esc_html__( 'Hide Entry Meta on Mobile', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input the entry meta tags that you want to hide on mobile devices, separate by comma. e.g. avatar, author... Keys include: [avatar, author, date, category, tag, view, comment, update, read, like, bookmark, custom]. Input -1 to re-enable all tags.', 'foxiz' ),
					'placeholder' => esc_html__( 'avatar,author', 'foxiz' ),
					'default'     => '',
				],
				[
					'id'       => $prefix . 'bookmark',
					'type'     => 'select',
					'title'    => esc_html__( 'Bookmark Icon', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the bookmark icon.', 'foxiz' ),
					'options'  => foxiz_config_switch_dropdown(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'entry_format',
					'type'     => 'select',
					'title'    => esc_html__( 'Post Format Icon', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select setting for the post format.', 'foxiz' ),
					'options'  => foxiz_config_entry_format( true ),
					'default'  => '0',
				],

				[
					'id'       => $prefix . 'excerpt',
					'type'     => 'select',
					'title'    => esc_html__( 'Excerpt', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable or select settings for the post excerpt.', 'foxiz' ),
					'options'  => foxiz_config_excerpt_dropdown(),
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'excerpt_length',
					'type'     => 'text',
					'class'    => 'small-text',
					'validate' => 'numeric',
					'title'    => esc_html__( 'Excerpt - Max Length', 'foxiz' ),
					'required' => [ $prefix . 'excerpt', '=', '1' ],
					'subtitle' => esc_html__( 'select max length of the post excerpt.', 'foxiz' ),
					'desc'     => esc_html__( 'Leave this option blank or set 0 to disable.', 'foxiz' ),
					'default'  => '',
				],
				[
					'id'          => $prefix . 'excerpt_source',
					'title'       => esc_html__( 'Excerpt - Source', 'foxiz' ),
					'subtitle'    => esc_html__( 'Where to get the post excerpt.', 'foxiz' ),
					'description' => esc_html__( 'When you select "use title tagline". if it is empty, it will fallback to the post excerpt or content.', 'foxiz' ),
					'required'    => [ $prefix . 'excerpt', '=', '1' ],
					'type'        => 'select',
					'options'     => foxiz_config_excerpt_source(),
					'default'     => 'tagline',
				],
				[
					'id'       => $prefix . 'hide_excerpt',
					'type'     => 'select',
					'title'    => esc_html__( 'Responsive - Hide Excerpt', 'foxiz' ),
					'subtitle' => esc_html__( 'Hide the post excerpt on tablet and mobile devices.', 'foxiz' ),
					'options'  => [
						'0'      => esc_html__( '- Default -', 'foxiz' ),
						'mobile' => esc_html__( 'On Mobile', 'foxiz' ),
						'tablet' => esc_html__( 'On Tablet', 'foxiz' ),
						'all'    => esc_html__( 'On Tablet & Mobile', 'foxiz' ),
						'-1'     => esc_html__( 'Disable', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'       => $prefix . 'readmore',
					'type'     => 'select',
					'title'    => esc_html__( 'Read More Button', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the read more button.', 'foxiz' ),
					'options'  => foxiz_config_switch_dropdown(),
					'default'  => '0',
				],
				[
					'id'     => 'section_end_search_design',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_search_pagination',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Post Listing - Pagination', 'foxiz' ),
					'subtitle' => esc_html__( 'These settings will only take effect if you select the Predefined layout for displaying the global post listing.', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'       => $prefix . 'pagination',
					'title'    => esc_html__( 'Pagination Type', 'foxiz' ),
					'subtitle' => esc_html__( 'Select pagination type for the search result listing.', 'foxiz' ),
					'type'     => 'select',
					'options'  => foxiz_config_blog_pagination(),
					'default'  => 'number',
				],
				[
					'id'     => 'section_end_search_pagination',
					'type'   => 'section',
					'class'  => 'ruby-section-end no-border',
					'indent' => false,
				],
			],
		];
	}
}

if ( ! function_exists( 'foxiz_register_options_page_404' ) ) {
	/**
	 * @return array
	 */
	function foxiz_register_options_page_404() {

		$prefix = 'page_404_';

		return [
			'id'     => 'foxiz_config_section_page_404',
			'title'  => esc_html__( '404 Page', 'foxiz' ),
			'icon'   => 'el el-info-circle',
			'desc'   => esc_html__( 'Customize the styles and content of your 404 error page.', 'foxiz' ),
			'fields' => [
				[
					'id'    => $prefix . 'featured_info',
					'type'  => 'info',
					'title' => esc_html__( 'Images will be resized to a maximum height of 300px. To ensure the best quality on retina screens, we recommend using images with a height of approximately 600px.', 'foxiz' ),
					'style' => 'warning',
				],
				[
					'id'     => 'section_start_' . $prefix . 'general',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'General', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => $prefix . 'featured',
					'type'     => 'media',
					'url'      => true,
					'preview'  => true,
					'title'    => esc_html__( 'Header Image', 'foxiz' ),
					'subtitle' => esc_html__( 'Upload a header image for the 404 page.', 'foxiz' ),
				],
				[
					'id'       => $prefix . 'dark_featured',
					'type'     => 'media',
					'url'      => true,
					'preview'  => true,
					'title'    => esc_html__( 'Dark Mode - Header Image', 'foxiz' ),
					'subtitle' => esc_html__( 'Upload a header image for the 404 page in dark mode.', 'foxiz' ),
				],
				[
					'id'       => $prefix . 'heading',
					'type'     => 'text',
					'title'    => esc_html__( 'Heading', 'foxiz' ),
					'subtitle' => esc_html__( 'Input a heading for the 404 page. Leave this option blank to set it as the default.', 'foxiz' ),
					'default'  => '',
				],
				[
					'id'       => $prefix . 'description',
					'title'    => esc_html__( 'Description', 'foxiz' ),
					'subtitle' => esc_html__( 'Input your description for the 404 page. Leave this option blank to set it as the default.', 'foxiz' ),
					'type'     => 'textarea',
					'rows'     => 2,
					'default'  => '',
				],
				[
					'id'       => $prefix . 'search',
					'type'     => 'switch',
					'title'    => esc_html__( 'Search Form', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the search form.', 'foxiz' ),
					'default'  => true,
				],
				[
					'id'     => 'section_end_' . $prefix . 'general',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_' . $prefix . 'template',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Template Builder', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'          => $prefix . 'template',
					'type'        => 'textarea',
					'rows'        => 2,
					'title'       => esc_html__( 'Template Shortcode', 'foxiz' ),
					'subtitle'    => esc_html__( 'Input a "Ruby Template" shortcode to display in the 404 page, e.g: [Ruby_E_Template id="1"]', 'foxiz' ),
					'placeholder' => '[Ruby_E_Template id="1"]',
					'default'     => '',
				],
				[
					'id'       => $prefix . 'template_w_content',
					'type'     => 'select',
					'title'    => esc_html__( 'Include 404 Page Content', 'foxiz' ),
					'subtitle' => esc_html__( 'Display the 404 page content above the template.', 'foxiz' ),
					'options'  => [
						'0'       => esc_html__( 'Template Only', 'foxiz' ),
						'content' => esc_html__( 'Width 404 Page Content', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'     => 'section_end_' . $prefix . 'template',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],

				[
					'id'       => 'section_start_' . $prefix . 'ad',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Ads Disabled', 'foxiz' ),
					'subtitle' => esc_html__( 'The setting will only apply for built-in ads. If you are using a third-party plugin to manage ads, adjustments may be required within the plugin\'s settings.', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'       => $prefix . 'ads',
					'type'     => 'select',
					'title'    => esc_html__( 'Ads on 404 Page', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the ad on the 404 page to comply with AdSense policy.', 'foxiz' ),
					'options'  => [
						'0' => esc_html__( '- Disable -', 'foxiz' ),
						'1' => esc_html__( 'Enable', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'     => 'section_end_' . $prefix . 'ad',
					'type'   => 'section',
					'class'  => 'ruby-section-end no-border',
					'indent' => false,
				],

			],
		];
	}
}