<?php
/** Don't load directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'foxiz_register_term_series_settings' ) ) {
	function foxiz_register_term_series_settings( $configs ) {

		$configs[] = [
			'title'      => esc_html__( 'Foxiz Show Settings', 'foxiz' ),
			'info'       => esc_html__( 'The settings will apply to this show only, and the ones below will take priority over other settings in the "Theme Options > Ruby Podcast > Show" settings', 'foxiz' ),
			'taxonomies' => [ 'series' ],
			'id'         => 'foxiz_category_meta',
			'tabs'       => [
				[
					'title' => esc_html__( 'Entry Show', 'foxiz' ),
					'id'    => 'entry-category',
					'icon'  => 'dashicons-art',
				],
				[
					'title' => esc_html__( 'Featured Image', 'foxiz' ),
					'id'    => 'show-featured',
					'icon'  => 'dashicons-format-gallery',
				],
				[
					'title' => esc_html__( 'Show Header', 'foxiz' ),
					'id'    => 'category-header',
					'icon'  => 'dashicons-editor-justify',
				],
				[
					'title' => esc_html__( 'Podcast', 'foxiz' ),
					'id'    => 'podcast',
					'icon'  => 'dashicons-album',
				],
				[
					'title' => esc_html__( 'Listing Queries', 'foxiz' ),
					'id'    => 'query',
					'icon'  => 'dashicons-database',
				],
				[
					'title' => esc_html__( 'Listing Template', 'foxiz' ),
					'id'    => 'global-template',
					'icon'  => 'dashicons-admin-site',
				],
				[
					'title' => esc_html__( 'Site Header', 'foxiz' ),
					'id'    => 'site-header',
					'icon'  => 'dashicons-heading',
				],
				[
					'title' => esc_html__( 'Podcast RSS', 'foxiz' ),
					'id'    => 'show-rss',
					'icon'  => 'dashicons-rss',
				],
			],
			'fields'     => [
				[
					'id'   => 'highlight_color',
					'name' => esc_html__( 'Highlight Color', 'foxiz' ),
					'desc' => esc_html__( 'Select a highlight color for the entry show.', 'foxiz' ),
					'info' => esc_html__( 'This setting will apply to the entry show in the blog listing.', 'foxiz' ),
					'tab'  => 'entry-category',
					'type' => 'color',
					'std'  => '',
				],
				[
					'id'   => 'dark_highlight_color',
					'name' => esc_html__( 'Dark Mode - Highlight Color', 'foxiz' ),
					'desc' => esc_html__( 'Select a highlight color in dark mode.', 'foxiz' ),
					'tab'  => 'entry-category',
					'type' => 'color',
					'std'  => '',
				],
				[
					'id'   => 'color',
					'name' => esc_html__( 'Accent Color', 'foxiz' ),
					'desc' => esc_html__( 'Select an accent (text) color for the entry show.', 'foxiz' ),
					'info' => esc_html__( 'This setting will apply to entry show text.', 'foxiz' ),
					'tab'  => 'entry-category',
					'type' => 'color',
					'std'  => '',
				],
				[
					'id'   => 'dark_color',
					'name' => esc_html__( 'Dark Mode - Accent Color', 'foxiz' ),
					'desc' => esc_html__( 'Select an accent (text) color in dark mode.', 'foxiz' ),
					'tab'  => 'entry-category',
					'type' => 'color',
					'std'  => '',
				],
				[
					'id'      => 'category_header',
					'name'    => esc_html__( 'Category Header', 'foxiz' ),
					'desc'    => esc_html__( 'Select a category header layout.', 'foxiz' ),
					'tab'     => 'category-header',
					'type'    => 'select',
					'options' => foxiz_config_category_header( true ),
					'std'     => '0',
				],
				[
					'id'   => 'featured_image',
					'name' => esc_html__( 'Featured Image', 'foxiz' ),
					'desc' => esc_html__( 'Upload featured images for this show.', 'foxiz' ),
					'tab'  => 'show-featured',
					'type' => 'image',
				],
				[
					'id'      => 'pattern',
					'name'    => esc_html__( 'Background Pattern', 'foxiz' ),
					'desc'    => esc_html__( 'Select a pattern style for the header background.', 'foxiz' ),
					'tab'     => 'category-header',
					'type'    => 'select',
					'options' => foxiz_config_archive_header_bg( true ),
					'std'     => '0',
				],
				[
					'id'      => 'breadcrumb',
					'name'    => esc_html__( 'Breadcrumb', 'foxiz' ),
					'desc'    => esc_html__( 'Enable or disable the breadcrumb in this show header.', 'foxiz' ),
					'tab'     => 'category-header',
					'type'    => 'select',
					'options' => [
						'0'  => esc_html__( '- Default -', 'foxiz' ),
						'1'  => esc_html__( 'Use Global Setting', 'foxiz' ),
						'-1' => esc_html__( 'Disable', 'foxiz' ),
					],
					'std'     => '0',
				],
				[
					'id'   => 'featured_file',
					'name' => esc_html__( 'Audio Intro Podcast File', 'foxiz' ),
					'desc' => esc_html__( 'Upload an introductory podcast (audio file) for this show.', 'foxiz' ),
					'tab'  => 'podcast',
					'type' => 'file',
				],
				[
					'id'          => 'listen_on_apple',
					'name'        => esc_html__( 'Listen on Apple Podcast', 'foxiz' ),
					'desc'        => esc_html__( 'Add an Apple podcast link for this show.', 'foxiz' ),
					'placeholder' => esc_html__( 'https://podcasts.apple.com...', 'foxiz' ),
					'tab'         => 'podcast',
					'type'        => 'text',
				],
				[
					'id'          => 'listen_on_spotify',
					'name'        => esc_html__( 'Listen on Spotify', 'foxiz' ),
					'desc'        => esc_html__( 'Add a Spotify link for this show.', 'foxiz' ),
					'placeholder' => esc_html__( 'https://open.spotify.com/...', 'foxiz' ),
					'tab'         => 'podcast',
					'type'        => 'text',
				],
				[
					'id'          => 'listen_on_soundcloud',
					'name'        => esc_html__( 'Listen on Soundcloud', 'foxiz' ),
					'desc'        => esc_html__( 'Add a Soundcloud link for this show.', 'foxiz' ),
					'placeholder' => esc_html__( 'https://soundcloud.com/...', 'foxiz' ),
					'tab'         => 'podcast',
					'type'        => 'text',
				],
				[
					'id'          => 'listen_on_google',
					'name'        => esc_html__( 'Listen on Google Podcast', 'foxiz' ),
					'desc'        => esc_html__( 'Add a Google podcast link for this show.', 'foxiz' ),
					'placeholder' => esc_html__( 'https://podcasts.google.com/...', 'foxiz' ),
					'tab'         => 'podcast',
					'type'        => 'text',
				],
				[
					'id'          => 'posts_per_page',
					'name'        => esc_html__( 'Posts per Page', 'foxiz' ),
					'desc'        => esc_html__( 'Input posts per page for this show.', 'foxiz' ),
					'info'        => esc_html__( 'This setting will apply to this category for both the Ruby Template and predefined layouts.', 'foxiz' ),
					'tab'         => 'query',
					'placeholder' => '10',
					'type'        => 'text',
					'classes'     => 'small',
					'std'         => '',
				],
				[
					'id'          => 'tag_not_in',
					'name'        => esc_html__( 'Exclude Tags Slug', 'foxiz' ),
					'desc'        => esc_html__( 'Remove episodes with this tag from the global blog query.', 'foxiz' ),
					'info'        => esc_html__( 'Separated by commas, this setting will also apply to the Global WP Query Template.', 'foxiz' ),
					'tab'         => 'query',
					'placeholder' => 'tag1,tag2,tag3',
					'type'        => 'text',
					'std'         => '',
				],
				[
					'id'      => 'order_by',
					'name'    => esc_html__( 'Order Episodes', 'foxiz' ),
					'desc'    => esc_html__( 'Order by episode index for this show', 'foxiz' ),
					'info'    => esc_html__( 'By default, the show will order episodes by publish date.', 'foxiz' ),
					'tab'     => 'query',
					'type'    => 'select',
					'options' => [
						'0'               => esc_html__( '- Default -', 'foxiz' ),
						'post_index'      => esc_html__( 'Episode Index ASC', 'foxiz' ),
						'post_index_desc' => esc_html__( 'Episode Index DECS', 'foxiz' ),
					],
					'std'     => '0',
				],
				[
					'id'          => 'template_global',
					'name'        => esc_html__( 'Use Ruby Template for the Post Listing', 'foxiz' ),
					'desc'        => esc_html__( 'Enter a "Ruby Template" shortcode here. This setting will take priority over all other settings.', 'foxiz' ),
					'info'        => esc_html__( 'Create a blog listing layout with Ruby Template via Elementor page builder and assign the template shortcode here to create your own layout.', 'foxiz' ),
					'tab'         => 'global-template',
					'type'        => 'textarea',
					'rows'        => '2',
					'placeholder' => '[Ruby_E_Template id="1"]',
					'std'         => '',
				],
				[
					'id'      => 'header_style',
					'name'    => esc_html__( 'Site Header', 'foxiz' ),
					'desc'    => esc_html__( 'Select a site header for this show.', 'foxiz' ),
					'tab'     => 'site-header',
					'type'    => 'select',
					'options' => foxiz_config_header_style( true, true ),
					'std'     => '0',
				],
				[
					'id'          => 'header_template',
					'name'        => esc_html__( 'Or Use Ruby Template for Site Header', 'foxiz' ),
					'desc'        => esc_html__( 'Input a Ruby Template shortcode for displaying as the website header for this show.', 'foxiz' ),
					'info'        => esc_html__( 'This setting will override all "Header Layout" settings. Leave it blank to disable.', 'foxiz' ),
					'tab'         => 'site-header',
					'type'        => 'textarea',
					'placeholder' => '[Ruby_E_Template id="1"]',
					'rows'        => '2',
					'std'         => '',
				],
				[
					'id'   => 'featured_rss',
					'name' => esc_html__( 'RSS Feature Image', 'foxiz' ),
					'desc' => esc_html__( 'Upload an RSS featured image for this show.', 'foxiz' ),
					'info' => esc_html__( 'The image should be square, with a size between 1400 and 3000px.', 'foxiz' ),
					'tab'  => 'show-rss',
					'type' => 'image',
				],
				[
					'id'          => 'itunes_category',
					'name'        => esc_html__( 'Apple Podcasts Categories', 'foxiz' ),
					'desc'        => esc_html__( 'Input the Apple Podcasts Categories (RSS supported), separated by commas.', 'foxiz' ),
					'placeholder' => 'News',
					'info'        => esc_html__( 'List of Categories: https://podcasters.apple.com/support/1691-apple-podcasts-categories', 'foxiz' ),
					'tab'         => 'show-rss',
					'type'        => 'text',
				],
				[
					'id'          => 'rss_email',
					'name'        => esc_html__( 'Owner\'s Email', 'foxiz' ),
					'desc'        => esc_html__( 'Enter the email of the show owner.', 'foxiz' ),
					'info'        => esc_html__( 'This email is used for feed verification.', 'foxiz' ),
					'placeholder' => 'admin@example.com',
					'tab'         => 'show-rss',
					'type'        => 'text',
				],
				[
					'id'   => 'rss_name',
					'name' => esc_html__( 'Owner\'s Name', 'foxiz' ),
					'desc' => esc_html__( 'Enter the name of the show owner.', 'foxiz' ),
					'tab'  => 'show-rss',
					'type' => 'text',
				],
			],
		];

		return $configs;
	}
}

add_filter( 'ruby_taxonomies', 'foxiz_register_term_series_settings', 11, 1 );