<?php
/** Don't load directly */
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'foxiz_register_options_login' ) ) {
	function foxiz_register_options_login() {

		return [
			'id'     => 'foxiz_config_section_login_screen',
			'title'  => esc_html__( 'Login', 'foxiz' ),
			'desc'   => esc_html__( 'Customize for the login screen and login popup.', 'foxiz' ),
			'icon'   => 'el el-wordpress',
			'fields' => [
				[
					'id'       => 'section_start_login_popup',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Popup Sign In', 'foxiz' ),
					'subtitle' => esc_html__( 'The popup login is supported for login button and personalized system if need.', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'       => 'disable_login_popup',
					'type'     => 'select',
					'title'    => esc_html__( 'Login Popup Supported', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable the pop-up sign-in throughout the entire website.', 'foxiz' ),
					'options'  => [
						'0' => esc_html__( '- Enable -', 'foxiz' ),
						'1' => esc_html__( 'Disable', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'          => 'login_form_hook',
					'type'        => 'switch',
					'title'       => esc_html__( 'Login_Form Hook', 'foxiz' ),
					'subtitle'    => esc_html__( 'Add the "login_form" hook in popup login form for better compatibility with login security plugins.', 'foxiz' ),
					'description' => esc_html__( 'This allows third-party plugins to add security checks, such as challenge questions or CAPTCHA, via this hook.', 'foxiz' ),
					'default'     => false,
				],
				[
					'id'       => 'header_login_heading',
					'type'     => 'text',
					'title'    => esc_html__( 'Form Heading', 'foxiz' ),
					'subtitle' => esc_html__( 'Input a heading for the login form.', 'foxiz' ),
					'default'  => esc_html__( 'Welcome Back!', 'foxiz' ),
				],
				[
					'id'       => 'header_login_description',
					'type'     => 'text',
					'title'    => esc_html__( 'Form Description', 'foxiz' ),
					'subtitle' => esc_html__( 'Input a description for the login form. Leave blank to set it as the default.', 'foxiz' ),
					'default'  => esc_html__( 'Sign in to your account', 'foxiz' ),
				],
				[
					'id'          => 'header_login_logo',
					'type'        => 'media',
					'title'       => esc_html__( 'Form Logo', 'foxiz' ),
					'subtitle'    => esc_html__( 'Adding a custom logo for the login form. Leave blank to set it as the default.', 'foxiz' ),
					'description' => esc_html__( 'Recommended for the logo height is 160px', 'foxiz' ),
					'url'         => true,
					'preview'     => true,
				],
				[
					'id'          => 'header_login_dark_logo',
					'type'        => 'media',
					'title'       => esc_html__( 'Dark Mode - Form Logo', 'foxiz' ),
					'subtitle'    => esc_html__( 'Adding a custom logo for the login form in dark mode.', 'foxiz' ),
					'description' => esc_html__( 'Recommended for the logo height is 160px', 'foxiz' ),
					'url'         => true,
					'preview'     => true,
				],
				[
					'id'          => 'login_popup_width',
					'type'        => 'text',
					'class'       => 'small-text',
					'validate'    => 'numeric',
					'title'       => esc_html__( 'Form Width', 'foxiz' ),
					'subtitle'    => esc_html__( 'Specify the maximum width of the login popup in pixels.', 'foxiz' ),
					'description' => esc_html__( ' This value determines how wide the popup can expand.', 'foxiz' ),
					'default'     => '350',
				],
				[
					'id'     => 'section_end_login_popup',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_login_screen',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Default Login Screen', 'foxiz' ),
					'subtitle' => esc_html__( 'This configuration will be effective to the default wp-login.php page.', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'       => 'login_screen_style',
					'title'    => esc_html__( 'Custom Login Screen', 'foxiz' ),
					'subtitle' => esc_html__( 'Enable or disable wp-login.php page style.', 'foxiz' ),
					'type'     => 'select',
					'options'  => [
						'0' => esc_html__( '- Disable -', 'foxiz' ),
						'1' => esc_html__( 'Enable', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'       => 'login_form_position',
					'title'    => esc_html__( 'Login Form Position', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a position for the login form.', 'foxiz' ),
					'type'     => 'select',
					'options'  => [
						'0' => esc_html__( '- Left -', 'foxiz' ),
						'1' => esc_html__( 'Center', 'foxiz' ),
						'2' => esc_html__( 'Right', 'foxiz' ),
					],
					'default'  => '0',
				],
				[
					'id'       => 'login_screen_logo',
					'type'     => 'media',
					'url'      => true,
					'preview'  => true,
					'title'    => esc_html__( 'Login Logo', 'foxiz' ),
					'subtitle' => esc_html__( 'Upload your logo for the logo screen. This option will override on wordpress logo.', 'foxiz' ),
				],
				[
					'id'          => 'logo_redirect',
					'type'        => 'text',
					'title'       => esc_html__( 'Logo - Destination URL', 'foxiz' ),
					'subtitle'    => esc_html__( 'Redirect to this link when clicking on the logo.', 'foxiz' ),
					'description' => esc_html__( 'Leave this option blank to redirect to the homepage.', 'foxiz' ),
					'default'     => '',
				],
				[
					'id'       => 'login_screen_bg',
					'type'     => 'background',
					'preview'  => true,
					'title'    => esc_html__( 'Login Screen Background', 'foxiz' ),
					'subtitle' => esc_html__( 'Upload your background for the logo screen.', 'foxiz' ),
					'default'  => [
						'background-size'       => 'cover',
						'background-attachment' => 'fixed',
						'background-repeat'     => 'no-repeat',
						'background-position'   => 'center center',
					],
				],
				[
					'id'          => 'login_color',
					'type'        => 'color',
					'transparent' => false,
					'title'       => esc_html__( 'Login Screen Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a color for the login screen.', 'foxiz' ),
					'default'     => '',
				],
				[
					'id'     => 'section_end_login_screen',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_login_custom',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Frontend Login and Registration Pages', 'foxiz' ),
					'subtitle' => [
						esc_html__( 'Ensure that links are specified as internal links.', 'foxiz' ),
						esc_html__( 'These settings define the frontend login and registration pages, which will be effective across the majority of login forms.', 'foxiz' ),
						esc_html__( 'You can create your custom frontend login page using the Elementor block "Foxiz - Login Form".', 'foxiz' ),
					],
					'indent'   => true,
				],
				[
					'id'          => 'login_page',
					'type'        => 'text',
					'title'       => esc_html__( 'Custom Login Page URL', 'foxiz' ),
					'subtitle'    => esc_html__( 'Enter the URL of your custom login page.', 'foxiz' ),
					'placeholder' => 'https://yourwebsite.com/login',
					'description' => esc_html__( 'This page must include the Elementor block "Foxiz - Login Form" to create a dedicated login page.', 'foxiz' ),
					'default'     => '',
				],
				[
					'id'          => 'login_register',
					'type'        => 'text',
					'title'       => esc_html__( 'Custom Registration Page URL', 'foxiz' ),
					'placeholder' => 'https://yourwebsite.com/register',
					'subtitle'    => esc_html__( 'Enter the URL of your custom registration page, if available.', 'foxiz' ),
					'description' => esc_html__( 'The registration form can be created using a third-party plugins registration form shortcode, such as WooCommerce or membership plugins.', 'foxiz' ),
					'default'     => '',
				],
				[
					'id'          => 'login_page_disable_logged',
					'type'        => 'switch',
					'title'       => esc_html__( 'Redirect Login/Register Page for Logged-In Users', 'foxiz' ),
					'subtitle'    => esc_html__( 'Automatically redirects logged-in users to the "Logged-In Redirect URL" specified below when they try to access the custom login or register page.', 'foxiz' ),
					'description' => esc_html__( 'Ensure that the "Logged-In Redirect URL" setting below is configured for this setting to function properly.', 'foxiz' ),
					'default'     => true,
				],
				[
					'id'          => 'login_redirect',
					'type'        => 'text',
					'title'       => esc_html__( 'Logged-In Redirect URL', 'foxiz' ),
					'placeholder' => 'https://yourwebsite.com/profile',
					'subtitle'    => esc_html__( 'Input the URL where users will be redirected after logging in.', 'foxiz' ),
					'default'     => '',
				],
				[
					'id'       => 'logout_redirect',
					'type'     => 'text',
					'title'    => esc_html__( 'Logout Redirect URL', 'foxiz' ),
					'subtitle' => esc_html__( 'Enter the URL where users will be redirected after logging out.', 'foxiz' ),
					'default'  => '',
				],
				[
					'id'     => 'section_end_login_custom',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_login_admin_bar',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Admin Bar', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'       => 'remove_admin_bar',
					'type'     => 'switch',
					'title'    => esc_html__( 'Disable Admin Bar', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable admin bar for all users except for Administrators', 'foxiz' ),
					'default'  => true,
				],
				[
					'id'       => 'remove_lang_bar',
					'type'     => 'switch',
					'title'    => esc_html__( 'Disable Language Bar', 'foxiz' ),
					'subtitle' => esc_html__( 'Disable the language bar in the login screen.', 'foxiz' ),
					'default'  => false,
				],
				[
					'id'     => 'section_end_login_admin_bar',
					'type'   => 'section',
					'class'  => 'ruby-section-end no-border',
					'indent' => false,
				],
			],
		];
	}
}
